/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.util;

public final class ExprTextUtils {
    private ExprTextUtils() {
    }

    public static String stripRedundantOuterParens(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        if (t.length() >= 2 && t.charAt(0) == '(' && t.charAt(t.length() - 1) == ')') {
            int depth = 0;
            for (int i = 0; i < t.length(); ++i) {
                char ch = t.charAt(i);
                if (ch == '(') {
                    ++depth;
                } else if (ch == ')') {
                    --depth;
                }
                if (depth != 0 || i >= t.length() - 1) continue;
                return t;
            }
            return t.substring(1, t.length() - 1).trim();
        }
        return t;
    }

    public static String parenthesizeIfNeededSimple(String s) {
        if (s == null) {
            return "()";
        }
        String t = s.trim();
        if (t.isEmpty()) {
            return "()";
        }
        if (t.charAt(0) == '(') {
            return t;
        }
        return "(" + t + ")";
    }

    public static String parenthesizeIfNeededExpr(String expr) {
        if (expr == null) {
            return "()";
        }
        String t = expr.trim();
        if (t.isEmpty()) {
            return "()";
        }
        if (t.charAt(0) == '(' && t.charAt(t.length() - 1) == ')') {
            int depth = 0;
            boolean spans = true;
            for (int i = 0; i < t.length(); ++i) {
                char ch = t.charAt(i);
                if (ch == '(') {
                    ++depth;
                } else if (ch == ')') {
                    --depth;
                }
                if (depth != 0 || i >= t.length() - 1) continue;
                spans = false;
                break;
            }
            if (spans) {
                return t;
            }
        }
        return "(" + t + ")";
    }
}

