/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb;

import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.IBreadcrumb;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionGroup;

public abstract class EditorBreadcrumb
implements IBreadcrumb {
    private GraphicalEditorWithFlyoutPalette fEditor;
    protected BreadcrumbViewer fBreadcrumbViewer;
    private boolean fIsActive;
    private Composite fComposite;
    private MenuManager menuManager;

    public EditorBreadcrumb(GraphicalEditorWithFlyoutPalette editor) {
        this.setEditor(editor);
    }

    protected abstract Object getCurrentInput();

    protected abstract BreadcrumbViewer createViewer(Composite var1);

    protected abstract boolean reveal(Object var1);

    protected abstract boolean open(Object var1);

    protected abstract ActionGroup createContextMenuActionGroup(ISelectionProvider var1);

    protected abstract void activateBreadcrumb();

    protected abstract void deactivateBreadcrumb();

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.fBreadcrumbViewer;
    }

    @Override
    public void setInput(Object element) {
        if (element == null) {
            return;
        }
        Object input = this.fBreadcrumbViewer.getInput();
        if (input == element || element.equals(input)) {
            return;
        }
        if (this.fBreadcrumbViewer.isDropDownOpen()) {
            return;
        }
        this.fBreadcrumbViewer.setInput(element);
    }

    @Override
    public void activate() {
        if (this.fBreadcrumbViewer.getSelection().isEmpty()) {
            this.fBreadcrumbViewer.setSelection((ISelection)new StructuredSelection(this.fBreadcrumbViewer.getInput()));
        }
    }

    @Override
    public boolean isActive() {
        return this.fIsActive;
    }

    @Override
    public Control createContent(Composite parent) {
        Assert.isTrue((this.fComposite == null ? 1 : 0) != 0, (String)"Content must only be created once.");
        boolean rtl = (this.getEditor().getSite().getShell().getStyle() & 0x4000000) != 0;
        this.fComposite = new Composite(parent, rtl ? 0x4000000 : 0);
        GridData data = new GridData(4, 128, true, false);
        this.fComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.fComposite.setLayout((Layout)gridLayout);
        this.fBreadcrumbViewer = this.createViewer(this.fComposite);
        this.fBreadcrumbViewer.getControl().setBackground(Display.getDefault().getSystemColor(1));
        this.fBreadcrumbViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditorBreadcrumb.this.doOpen(event.getSelection());
            }
        });
        this.fBreadcrumbViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                EditorBreadcrumb.this.doRevealOrOpen(event.getSelection());
            }
        });
        this.fBreadcrumbViewer.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                BreadcrumbViewer selectionProvider = EditorBreadcrumb.this.fBreadcrumbViewer.isDropDownOpen() ? EditorBreadcrumb.this.fBreadcrumbViewer.getDropDownSelectionProvider() : EditorBreadcrumb.this.fBreadcrumbViewer;
                if (EditorBreadcrumb.this.getMenuManager() == null) {
                    EditorBreadcrumb.this.menuManager = new MenuManager();
                    Object element = selectionProvider.getSelection();
                    if (selectionProvider.getSelection() instanceof StructuredSelection) {
                        element = ((StructuredSelection)selectionProvider.getSelection()).getFirstElement();
                    }
                    EditorBreadcrumb.this.createContextMenu(element, EditorBreadcrumb.this.menuManager);
                    if (EditorBreadcrumb.this.menuManager.isEmpty()) {
                        return;
                    }
                    EditorBreadcrumb.this.getEditor().getEditorSite().registerContextMenu(EditorBreadcrumb.this.menuManager, (ISelectionProvider)selectionProvider, false);
                }
                Menu menu = EditorBreadcrumb.this.menuManager.createContextMenu(EditorBreadcrumb.this.fBreadcrumbViewer.getControl());
                menu.setLocation(event.x + 10, event.y + 10);
                menu.setVisible(true);
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (menu.getDisplay().readAndDispatch()) continue;
                    menu.getDisplay().sleep();
                }
            }
        });
        return this.fComposite;
    }

    protected MenuManager getMenuManager() {
        return this.menuManager;
    }

    public void setMenuManager(MenuManager menuManager) {
        this.menuManager = menuManager;
    }

    protected abstract void createContextMenu(Object var1, MenuManager var2);

    @Override
    public void dispose() {
        this.setEditor(null);
    }

    private void doRevealOrOpen(ISelection selection) {
        if (this.doReveal(selection)) {
            this.fEditor.getGraphicalViewer().getControl().setFocus();
        } else if (this.doOpen(selection)) {
            this.fIsActive = false;
            this.fBreadcrumbViewer.setInput(this.getCurrentInput());
        }
    }

    private boolean doOpen(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return false;
        }
        return this.open(structuredSelection.getFirstElement());
    }

    private boolean doReveal(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return false;
        }
        return this.reveal(structuredSelection.getFirstElement());
    }

    protected void setEditor(GraphicalEditorWithFlyoutPalette editor) {
        this.fEditor = editor;
        if (this.fEditor == null) {
            return;
        }
    }

    protected GraphicalEditorWithFlyoutPalette getEditor() {
        return this.fEditor;
    }
}

