/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.IDelaySelectionDragTracker;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ReportElementDragTracker
extends DragEditPartsTracker {
    private static final int FLAG_DELAY_SELECTION = 512;
    protected static final int MAX_FLAG = 512;
    private DelaySelectionHelper activeHelper = null;
    private static final int DELAY_TIME = 1200;
    private IDelaySelectionDragTracker proxy;

    public ReportElementDragTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected boolean handleButtonDown(int button) {
        if (this.getCurrentViewer() instanceof DeferredGraphicalViewer) {
            ((DeferredGraphicalViewer)this.getCurrentViewer()).initStepDat();
        }
        boolean bool = super.handleButtonDown(button);
        if (!this.getFlag(512) && this.getCurrentInput().isMouseButtonDown(1)) {
            new DelaySelectionHelper();
            this.setFlag(512, true);
        }
        return bool;
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if (this.proxy != null) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.proxy.mouseUp(me, viewer);
            this.proxy = null;
            return;
        }
        this.activeHelper = null;
        super.mouseUp(me, viewer);
    }

    protected boolean handleDragInProgress() {
        if (this.proxy != null) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.proxy.setLocation(this.getLocation());
            this.proxy.setViewer(this.getCurrentViewer());
            return this.proxy.handleDragInProgress();
        }
        this.activeHelper = null;
        return super.handleDragInProgress();
    }

    protected void resetFlags() {
        super.resetFlags();
        this.setFlag(512, false);
    }

    private EditPart getEditPartUnderMouse() {
        if (this.getCurrentViewer() == null) {
            return null;
        }
        EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), new ArrayList());
        return editPart;
    }

    public void mouseDoubleClick(MouseEvent me, EditPartViewer viewer) {
        this.activeHelper = null;
        super.mouseDoubleClick(me, viewer);
    }

    class DelaySelectionHelper
    implements Runnable {
        private FocusListener focus;
        private KeyListener key;

        public DelaySelectionHelper() {
            ReportElementDragTracker.this.activeHelper = this;
            this.hookControl(ReportElementDragTracker.this.getSourceEditPart().getViewer().getControl());
            Display.getCurrent().timerExec(1200, (Runnable)this);
        }

        void abort() {
            ReportElementDragTracker.this.activeHelper = null;
        }

        void hookControl(Control control) {
            this.focus = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    DelaySelectionHelper.this.abort();
                }
            };
            control.addFocusListener(this.focus);
            this.key = new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    DelaySelectionHelper.this.abort();
                }

                public void keyReleased(KeyEvent e) {
                    DelaySelectionHelper.this.abort();
                }
            };
            control.addKeyListener(this.key);
        }

        @Override
        public void run() {
            if (!ReportElementDragTracker.this.getSourceEditPart().isActive()) {
                return;
            }
            EditPartViewer viewer = ReportElementDragTracker.this.getSourceEditPart().getViewer();
            EditPart parent = ReportElementDragTracker.this.getSourceEditPart().getParent();
            if (ReportElementDragTracker.this.activeHelper == this && ReportElementDragTracker.this.getSourceEditPart().isActive() && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                viewer.getControl().removeFocusListener(this.focus);
                viewer.getControl().removeKeyListener(this.key);
                if (viewer.getSelectedEditParts().size() == 1) {
                    if (parent.getAdapter(IDelaySelectionDragTracker.class) != null) {
                        ReportElementDragTracker.this.proxy = (IDelaySelectionDragTracker)parent.getAdapter(IDelaySelectionDragTracker.class);
                        if (viewer instanceof DeferredGraphicalViewer) {
                            ((DeferredGraphicalViewer)viewer).setSelection((ISelection)new StructuredSelection((Object)ReportElementDragTracker.this.proxy.getSourceEditPart()), true);
                        }
                        if (ReportElementDragTracker.this.getSourceEditPart() != ReportElementDragTracker.this.getEditPartUnderMouse()) {
                            IFigure figure = ((GraphicalEditPart)ReportElementDragTracker.this.getSourceEditPart()).getFigure();
                            Rectangle center = figure.getBounds().getCopy();
                            figure.translateToAbsolute((Translatable)center);
                            ReportElementDragTracker.this.proxy.setStartLocation(center.getCenter());
                        } else {
                            ReportElementDragTracker.this.proxy.setStartLocation(ReportElementDragTracker.this.getStartLocation());
                        }
                        ReportElementDragTracker.this.proxy.setState(4);
                    }
                    ReportElementDragTracker.this.setFlag(512, true);
                } else {
                    ReportElementDragTracker.this.setFlag(512, false);
                }
            } else {
                ReportElementDragTracker.this.setFlag(512, false);
            }
            ReportElementDragTracker.this.activeHelper = null;
        }
    }
}

