/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util.graphics;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class BirtImageLoader {
    private static final String IMG_PREFIX = "image/";
    private static final String ICO = "ico";
    private static final String MIME_ICO = "x-icon";
    private static final String SVG = "svg";
    private static final String MIME_SVG = "svg+xml";
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("EmbeddedImage").getMember("type").getAllowedChoices();

    public byte[] load(String fileName) throws IOException {
        byte[] data;
        block8: {
            FileInputStream file = null;
            data = null;
            try {
                file = new FileInputStream(fileName);
                if (file == null) break block8;
                data = new byte[file.available()];
                file.read(data);
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        return data;
    }

    public EmbeddedImage save(ModuleHandle handle, String fileName) throws SemanticException, IOException {
        return this.save(handle, fileName, fileName);
    }

    public EmbeddedImage save(ModuleHandle handle, String fileName, String imageName) throws SemanticException, IOException {
        EmbeddedImage embeddedImage = StructureFactory.createEmbeddedImage();
        embeddedImage.setType(this.getModelImageType(imageName));
        embeddedImage.setName(imageName);
        embeddedImage.setData(this.load(fileName));
        handle.addImage(embeddedImage);
        return embeddedImage;
    }

    private String getModelImageType(String imageName) {
        if (imageName.lastIndexOf(".") > -1) {
            String suffix = imageName.substring(imageName.lastIndexOf(".") + 1).toLowerCase();
            String type = IMG_PREFIX + suffix;
            if (SVG.equals(suffix)) {
                type = "image/svg+xml";
            } else if (ICO.equals(suffix)) {
                type = "image/x-icon";
            }
            IChoice[] iChoiceArray = DATA_TYPE_CHOICE_SET.getChoices();
            int n = iChoiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IChoice choice = iChoiceArray[n2];
                if (choice.getValue().equals(type)) {
                    return choice.getValue().toString();
                }
                ++n2;
            }
        }
        return null;
    }
}

