/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.io.File;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishLibraryWizard;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PublishLibraryAction
implements IWorkbenchWindowActionDelegate {
    private IFile libFile = null;
    private boolean selectLibrary = false;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        String fileName = null;
        LibraryHandle libHandle = null;
        if (!this.editLibrary() && !this.selectLibrary) {
            return;
        }
        if (this.editLibrary()) {
            ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
            String filePath = module.getFileName();
            fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            libHandle = (LibraryHandle)module;
        } else if (this.libFile != null && this.libFile.getFileExtension().equals("rptlibrary")) {
            String url = this.libFile.getLocation().toOSString();
            LibraryHandle handle = null;
            try {
                try {
                    handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(url);
                    String filePath = handle.getFileName();
                    if (filePath != null && filePath.length() != 0) {
                        fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
                    }
                    libHandle = handle;
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                    if (handle != null) {
                        handle.close();
                    }
                    return;
                }
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
        }
        if (fileName != null && libHandle != null) {
            PublishLibraryWizard publishLibrary = new PublishLibraryWizard(libHandle, fileName, ReportPlugin.getDefault().getResourceFolder());
            BaseWizardDialog dialog = new BaseWizardDialog(UIUtil.getDefaultShell(), (IWizard)publishLibrary);
            dialog.setPageSize(500, 250);
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TreeSelection) {
            IFile file = null;
            if (((TreeSelection)selection).getFirstElement() instanceof IFile) {
                file = (IFile)((TreeSelection)selection).getFirstElement();
            }
            if (file != null) {
                if (file.getFileExtension() != null && file.getFileExtension().equals("rptlibrary")) {
                    this.libFile = file;
                    this.selectLibrary = true;
                    action.setEnabled(true);
                } else {
                    this.libFile = null;
                    this.selectLibrary = false;
                    action.setEnabled(false);
                }
                return;
            }
        }
        this.libFile = null;
        this.selectLibrary = false;
        action.setEnabled(this.isEnable());
    }

    private boolean isEnable() {
        return this.editLibrary();
    }

    private boolean editLibrary() {
        IEditorPart editor = UIUtil.getActiveEditor(true);
        if (editor != null) {
            return editor.getEditorInput().getName().endsWith(".rptlibrary");
        }
        return false;
    }
}

