/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.optimizer;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionInterner;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.CommitTransactionTask;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.OptimizerTask;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class Optimizer
extends Lifecycle {
    private final LissomeStore store;
    private final boolean async;
    private final LinkedList<OptimizerTask> queue = new LinkedList();
    private Worker worker;
    private Cache cache;

    public Optimizer(LissomeStore store, boolean async) {
        this.store = store;
        this.async = async;
    }

    public LissomeStore getStore() {
        return this.store;
    }

    public boolean isAsync() {
        return this.async;
    }

    public OptimizerTask[] getTasks() {
        return this.getCache().getTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(OptimizerTask task) {
        LinkedList<OptimizerTask> linkedList = this.queue;
        synchronized (linkedList) {
            this.cache = null;
            this.queue.addLast(task);
            this.queue.notifyAll();
        }
        if (!this.async) {
            try {
                this.executeFirstTask();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void executeFirstTask() throws InterruptedException {
        try {
            OptimizerTask task = this.getFirstTask();
            task.execute(this);
            this.removeFirstTask();
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OptimizerTask getFirstTask() throws InterruptedException {
        OptimizerTask task;
        LinkedList<OptimizerTask> linkedList = this.queue;
        synchronized (linkedList) {
            while (this.queue.isEmpty()) {
                this.queue.wait(100L);
            }
            task = this.queue.getFirst();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFirstTask() {
        LinkedList<OptimizerTask> linkedList = this.queue;
        synchronized (linkedList) {
            this.cache = null;
            this.queue.removeFirst();
            this.queue.notifyAll();
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.async) {
            this.worker = new TaskWorker();
            this.worker.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        LinkedList<OptimizerTask> linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.queue.isEmpty()) {
                this.queue.wait(100L);
            }
        }
        if (this.async) {
            this.worker.deactivate();
            this.worker = null;
        }
        super.doDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Cache getCache() {
        LinkedList<OptimizerTask> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.cache == null) {
                boolean supportingBranches = this.store.getRepository().isSupportingBranches();
                this.cache = new Cache(this.queue, supportingBranches);
            }
            return this.cache;
        }
    }

    public boolean queryResources(IStoreAccessor.QueryResourcesContext context) {
        Cache cache = this.getCache();
        return cache.queryResources(context);
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint) {
        Cache cache = this.getCache();
        return cache.readRevision(id, branchPoint);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
    }

    private static final class Cache {
        private final OptimizerTask[] tasks;
        private final boolean supportingBranches;
        private InternalCDORevisionCache revisionCache;

        public Cache(LinkedList<OptimizerTask> queue, boolean supportingBranches) {
            this.supportingBranches = supportingBranches;
            this.tasks = queue.toArray(new OptimizerTask[queue.size()]);
        }

        public OptimizerTask[] getTasks() {
            return this.tasks;
        }

        public synchronized CDORevisionCache getRevisionCache() {
            if (this.revisionCache == null) {
                this.revisionCache = (InternalCDORevisionCache)CDORevisionUtil.createRevisionCache((boolean)true, (boolean)this.supportingBranches);
                CDORevisionInterner interner = new CDORevisionInterner(){

                    public CDORevision internRevision(CDORevision revision) {
                        this.reviseOldRevision(revision);
                        return revisionCache.internRevision(revision);
                    }

                    private void reviseOldRevision(CDORevision revision) {
                        int version = revision.getVersion();
                        if (version > 1) {
                            CDOID id = revision.getID();
                            CDOBranchVersion oldVersion = revision.getBranch().getVersion(version - 1);
                            InternalCDORevision oldRevision = (InternalCDORevision)revisionCache.getRevisionByVersion(id, oldVersion);
                            if (oldRevision != null) {
                                oldRevision.setRevised(revision.getTimeStamp() - 1L);
                            }
                        }
                    }
                };
                OptimizerTask[] optimizerTaskArray = this.tasks;
                int n = this.tasks.length;
                int n2 = 0;
                while (n2 < n) {
                    OptimizerTask task = optimizerTaskArray[n2];
                    if (task instanceof CommitTransactionTask) {
                        CommitTransactionTask commitTask = (CommitTransactionTask)task;
                        commitTask.cacheRevisions(interner);
                    }
                    ++n2;
                }
            }
            return this.revisionCache;
        }

        public boolean queryResources(IStoreAccessor.QueryResourcesContext context) {
            InternalCDORevisionCache revisionCache = (InternalCDORevisionCache)this.getRevisionCache();
            for (CDORevision revision : revisionCache.getRevisions((CDOBranchPoint)context)) {
                boolean match;
                CDOID folderID;
                if (!revision.isResourceNode() || !ObjectUtil.equals((Object)(folderID = (CDOID)revision.data().getContainerID()), (Object)context.getFolderID())) continue;
                String name = context.getName();
                String revisionName = (String)revision.data().get((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, 0);
                boolean useEquals = context.exactMatch() || revisionName == null || name == null;
                boolean bl = match = useEquals ? ObjectUtil.equals((Object)revisionName, (Object)name) : revisionName.startsWith(name);
                if (!match || context.addResource(revision.getID())) continue;
                return false;
            }
            return true;
        }

        public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint) {
            CDORevisionCache revisionCache = this.getRevisionCache();
            return (InternalCDORevision)revisionCache.getRevision(id, branchPoint);
        }
    }

    private final class TaskWorker
    extends Worker {
        private TaskWorker() {
        }

        protected String getThreadName() {
            return "OptimizerTaskWorker";
        }

        protected void work(Worker.WorkContext context) throws Exception {
            Optimizer.this.executeFirstTask();
        }
    }
}

