/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.qt.core.index.IQMakeEnv;
import org.eclipse.cdt.internal.qt.core.index.IQMakeEnv2;
import org.eclipse.cdt.internal.qt.core.index.IQMakeEnvProvider;
import org.eclipse.cdt.internal.qt.core.index.QMakeEnvInfo;
import org.eclipse.cdt.internal.qt.core.index.QMakeEnvProviderDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class QMakeEnvProviderManager {
    private static QMakeEnvProviderManager INSTANCE = new QMakeEnvProviderManager();
    private final List<QMakeEnvProviderDescriptor> descriptors = QMakeEnvProviderManager.loadDescriptors();

    public static QMakeEnvProviderManager getInstance() {
        return INSTANCE;
    }

    private QMakeEnvProviderManager() {
    }

    private static List<QMakeEnvProviderDescriptor> loadDescriptors() {
        IConfigurationElement[] elements;
        ArrayList<QMakeEnvProviderDescriptor> descriptors = new ArrayList<QMakeEnvProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.qt.core", "qmakeEnvProvider");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            descriptors.add(new QMakeEnvProviderDescriptor(element));
            ++n2;
        }
        Collections.sort(descriptors);
        return descriptors;
    }

    public IQMakeEnv createEnv(IQMakeEnvProvider.IController controller) {
        for (QMakeEnvProviderDescriptor descriptor : this.descriptors) {
            IQMakeEnv env = descriptor.createEnv(controller);
            if (env == null) continue;
            return env;
        }
        return new ConfigurationQMakeEnv(controller.getConfiguration());
    }

    private static class ConfigurationQMakeEnv
    implements IQMakeEnv2 {
        private static final String PRO_FILE_SUFFIX = ".pro";
        private static final String ENV_VAR_QMAKE = "QMAKE";
        private final ICConfigurationDescription configuration;

        public ConfigurationQMakeEnv(ICConfigurationDescription configuration) {
            this.configuration = configuration;
        }

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public QMakeEnvInfo getQMakeEnvInfo() {
            if (this.configuration == null) {
                return null;
            }
            IProject project = this.configuration.getProjectDescription().getProject();
            IFile proFile = project != null ? project.getFile(String.valueOf(project.getName()) + PRO_FILE_SUFFIX) : null;
            IEnvironmentVariable variable = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_VAR_QMAKE, this.configuration, true);
            String qmakeFilePath = variable != null ? variable.getValue() : null;
            return new QMakeEnvInfo(proFile, qmakeFilePath, Collections.emptyMap(), Collections.emptyList());
        }
    }
}

