/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core.qmldir;

import java.io.InputStream;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.qt.core.location.Position;
import org.eclipse.cdt.internal.qt.core.location.SourceLocation;
import org.eclipse.cdt.qt.core.location.ISourceLocation;

public class QMLDirectoryLexer {
    private Scanner input;
    private MatchResult lastMatch;
    private int currentLine;
    private int currentLineStart;

    public void setInput(InputStream input) {
        this.input = new Scanner(input);
        this.lastMatch = null;
        this.currentLine = 1;
        this.currentLineStart = 0;
    }

    public Token nextToken() throws IllegalArgumentException {
        return this.nextToken(true);
    }

    public Token nextToken(boolean skipWhitespace) throws IllegalArgumentException {
        if (this.input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (this.input.findWithinHorizon(TokenType.patternForAllTerminals(), 0) == null) {
            if (this.lastMatch != null) {
                return new Token(TokenType.EOF, "", this.lastMatch.end(), this.lastMatch.end(), this.currentLine, this.currentLineStart);
            }
            return new Token(TokenType.EOF, "", 0, 0, 1, 0);
        }
        int groupNo = 1;
        TokenType[] tokenTypeArray = TokenType.values();
        int n = tokenTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TokenType t = tokenTypeArray[n2];
            if (t.regex != null) {
                if (this.input.match().start(groupNo) != -1) {
                    this.lastMatch = this.input.match();
                    Token next = null;
                    next = !t.equals((Object)TokenType.WHITESPACE) || !skipWhitespace ? new Token(t, this.input.match(), this.currentLine, this.currentLineStart) : this.nextToken(skipWhitespace);
                    if (t.equals((Object)TokenType.COMMAND_END)) {
                        ++this.currentLine;
                        this.currentLineStart = this.input.match().end();
                    }
                    return next;
                }
                ++groupNo;
            }
            ++n2;
        }
        return new Token(TokenType.UNKNOWN, this.input.match(), this.currentLine, this.currentLineStart);
    }

    public static class Token {
        private final TokenType tokType;
        private final String raw;
        private final ISourceLocation location;
        private final int start;
        private final int end;

        private Token(TokenType type, MatchResult match, int line, int lineStart) {
            this(type, match.group(), match.start(), match.end(), line, lineStart);
        }

        private Token(TokenType type, String raw, int start, int end, int line, int lineStart) {
            this.tokType = type;
            raw = raw.replaceAll("\n", "\\\\n");
            this.raw = raw = raw.replaceAll("\r", "\\\\r");
            this.start = start;
            this.end = end;
            this.location = new SourceLocation(null, new Position(line, start - lineStart), new Position(line, end - lineStart));
        }

        public TokenType getType() {
            return this.tokType;
        }

        public String getText() {
            return this.raw;
        }

        public ISourceLocation getLocation() {
            return this.location;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    public static enum TokenType {
        COMMENT("#.*$"),
        MODULE("module(?=\\s|$)"),
        TYPEINFO("typeinfo(?=\\s|$)"),
        SINGLETON("singleton(?=\\s|$)"),
        INTERNAL("internal(?=\\s|$)"),
        PLUGIN("plugin(?=\\s|$)"),
        CLASSNAME("classname(?=\\s|$)"),
        DEPENDS("depends(?=\\s|$)"),
        DESIGNERSUPPORTED("designersupported(?=\\s|$)"),
        WORD("[^0-9\\s][^\\s]*"),
        DECIMAL("[0-9]+\\.[0-9]+"),
        INTEGER("[0-9]+"),
        WHITESPACE("\\h+"),
        COMMAND_END("(?:\r\n)|\n"),
        UNKNOWN(".+"),
        EOF(null);

        private static Pattern pattern;
        private final String regex;

        private static Pattern patternForAllTerminals() {
            if (pattern == null) {
                String regex = "";
                TokenType[] tokens = TokenType.values();
                int i = 0;
                while (i < TokenType.values().length) {
                    TokenType tok = tokens[i];
                    if (tok.regex != null) {
                        if (i != 0) {
                            regex = String.valueOf(regex) + "|";
                        }
                        regex = String.valueOf(regex) + "(" + tok.regex + ")";
                    }
                    ++i;
                }
                pattern = Pattern.compile(regex, 8);
            }
            return pattern;
        }

        private TokenType(String regex) {
            this.regex = regex;
        }
    }
}

