/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x.refactorparticipants;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.tools.emf.editor3x.RefactorModel;
import org.eclipse.e4.tools.emf.editor3x.extension.Util;
import org.eclipse.e4.tools.emf.editor3x.refactorparticipants.RefactorParticipantDelegate;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ModelRenameParticipant
extends RenameParticipant {
    private IType fType;
    private IPackageFragment fPckage;
    private IFile fFile;
    private IFolder fFolder;
    private IProject fProject;
    private RefactorModel refactorModel;

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this.fType = (IType)element;
            return true;
        }
        if (element instanceof IPackageFragment) {
            this.fPckage = (IPackageFragment)element;
            return true;
        }
        if (element instanceof IFile) {
            this.fFile = (IFile)element;
            return true;
        }
        if (element instanceof IFolder) {
            this.fFolder = (IFolder)element;
            return true;
        }
        if (element instanceof IProject) {
            this.fProject = (IProject)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Workbench Model Contribution Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.refactorModel = RefactorModel.getModel((RefactoringParticipant)this);
        if (this.fType != null) {
            return this.createClassChange(pm, this.fType);
        }
        if (this.fPckage != null) {
            return this.createPackageChange(pm, this.fPckage);
        }
        if (this.fFile != null) {
            return this.createFileChange(pm, this.fFile);
        }
        if (this.fFolder != null) {
            return this.createFolderChange(pm, this.fFolder);
        }
        if (this.fProject != null) {
            return this.createProjectChange(pm, this.fProject);
        }
        return null;
    }

    private Change createProjectChange(IProgressMonitor pm, IProject project) throws CoreException {
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        this.refactorModel.addTextRename("platform:/plugin/" + project.getName() + "/", "platform:/plugin/" + this.getArguments().getNewName() + "/");
        this.refactorModel.addTextRename("bundleclass://" + project.getName() + "/", "bundleclass://" + this.getArguments().getNewName() + "/");
        this.refactorModel.setProjectRename(project, ((IWorkspaceRoot)project.getParent()).getProject(this.getArguments().getNewName()));
        return RefactorParticipantDelegate.createChange(pm, this.refactorModel);
    }

    private Change createFolderChange(IProgressMonitor pm, IFolder folder) throws CoreException {
        String SPLIT = "/";
        if (folder.getParent().getFullPath().segmentCount() == 1) {
            SPLIT = "";
        }
        String newUrl = "platform:/plugin/" + folder.getProject().getName() + "/" + folder.getParent().getProjectRelativePath().toString() + SPLIT + this.getArguments().getNewName();
        String oldUrl = "platform:/plugin" + folder.getFullPath();
        this.refactorModel.addTextRename(oldUrl, newUrl);
        return RefactorParticipantDelegate.createChange(pm, this.refactorModel);
    }

    private Change createFileChange(IProgressMonitor pm, IFile file) throws CoreException {
        String SPLIT = "/";
        if (file.getParent().getFullPath().segmentCount() == 1) {
            SPLIT = "";
        }
        String newUrl = "platform:/plugin/" + file.getProject().getName() + "/" + file.getParent().getProjectRelativePath().toString() + SPLIT + this.getArguments().getNewName();
        String oldUrl = "platform:/plugin" + file.getFullPath();
        this.refactorModel.addTextRename(oldUrl, newUrl);
        return RefactorParticipantDelegate.createChange(pm, this.refactorModel);
    }

    private Change createPackageChange(IProgressMonitor pm, IPackageFragment pckage) throws CoreException {
        String bundle = Util.getBundleSymbolicName(pckage.getJavaProject().getProject());
        String newUrl = "bundleclass://" + bundle + "/" + this.getArguments().getNewName();
        String oldUrl = "bundleclass://" + bundle + "/" + pckage.getElementName();
        this.refactorModel.addTextRename(oldUrl, newUrl);
        return RefactorParticipantDelegate.createChange(pm, this.refactorModel);
    }

    private Change createClassChange(IProgressMonitor pm, IType type) throws CoreException {
        String bundle = Util.getBundleSymbolicName(type.getJavaProject().getProject());
        String newUrl = "bundleclass://" + bundle + "/" + (type.getPackageFragment().getElementName().length() == 0 ? this.getArguments().getNewName() : String.valueOf(type.getPackageFragment().getElementName()) + "." + this.getArguments().getNewName());
        String oldUrl = "bundleclass://" + bundle + "/" + type.getFullyQualifiedName();
        this.refactorModel.addTextRename(oldUrl, newUrl);
        return RefactorParticipantDelegate.createChange(pm, this.refactorModel);
    }
}

