/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.build.BuildObject;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.core.bundle.BundleObject;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.AttributeChangedEvent;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginLibraryNode;
import org.eclipse.pde.internal.core.text.plugin.PluginObjectNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class PluginUndoManager
extends ModelUndoManager {
    public PluginUndoManager(PDEFormEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    @Override
    protected String getPageId(Object obj) {
        if (obj instanceof IPluginBase) {
            return "overview";
        }
        if (obj instanceof IPluginImport) {
            return "dependencies";
        }
        if (obj instanceof IPluginLibrary || obj instanceof IPluginElement && ((IPluginElement)obj).getParent() instanceof IPluginLibrary) {
            return "runtime";
        }
        if (obj instanceof IPluginExtension || obj instanceof IPluginElement && ((IPluginElement)obj).getParent() instanceof IPluginParent || obj instanceof IPluginAttribute) {
            return "extensions";
        }
        if (obj instanceof IPluginExtensionPoint) {
            return "ex-points";
        }
        return null;
    }

    @Override
    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        IModelChangeProvider model = event.getChangeProvider();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (event instanceof AttributeChangedEvent) {
                    this.executeAttributeChange((AttributeChangedEvent)event, undo);
                    break;
                }
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeAdd(IModelChangeProvider model, Object[] elements) {
        IPluginBase pluginBase = null;
        IBuild build = null;
        IBundleModel bundleModel = null;
        if (model instanceof IPluginModelBase) {
            pluginBase = ((IPluginModelBase)model).getPluginBase();
        } else if (model instanceof IBuildModel) {
            build = ((IBuildModel)model).getBuild();
        } else if (model instanceof IBundleModel) {
            bundleModel = (IBundleModel)model;
        }
        try {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IPluginImport) {
                    pluginBase.add((IPluginImport)element);
                } else if (element instanceof IPluginLibrary) {
                    pluginBase.add((IPluginLibrary)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    pluginBase.add((IPluginExtensionPoint)element);
                } else if (element instanceof IPluginExtension) {
                    pluginBase.add((IPluginExtension)element);
                } else {
                    Object object = element;
                    if (object instanceof IPluginElement) {
                        void e;
                        IPluginElement cfr_ignored_0 = (IPluginElement)object;
                        IPluginElement cfr_ignored_1 = (IPluginElement)object;
                        IBuildEntry parent = e.getParent();
                        if (parent instanceof PluginLibraryNode && e instanceof PluginElementNode) {
                            ((PluginLibraryNode)parent).addContentFilter((PluginElementNode)e);
                        } else if (parent instanceof IPluginParent) {
                            ((IPluginParent)parent).add((IPluginObject)e);
                        }
                    } else {
                        Object object2 = element;
                        if (object2 instanceof IBuildEntry) {
                            void e;
                            IBuildEntry cfr_ignored_2 = (IBuildEntry)object2;
                            IBuildEntry cfr_ignored_3 = (IBuildEntry)object2;
                            build.add((IBuildEntry)e);
                        } else if (element instanceof BundleObject) {
                            IBaseModel aggModel;
                            IBaseModel iBaseModel;
                            IManifestHeader header;
                            if (element instanceof ImportPackageObject && (header = bundleModel.getBundle().getManifestHeader("Import-Package")) != null && header instanceof ImportPackageHeader) {
                                ((ImportPackageHeader)header).addPackage((PackageObject)element);
                            }
                            if (element instanceof RequireBundleObject && (iBaseModel = (aggModel = this.getEditor().getAggregateModel())) instanceof BundlePluginModel) {
                                boolean exported;
                                void pluginModel;
                                BundlePluginModel cfr_ignored_4 = (BundlePluginModel)iBaseModel;
                                BundlePluginModel cfr_ignored_5 = (BundlePluginModel)iBaseModel;
                                RequireBundleObject requireBundle = (RequireBundleObject)element;
                                pluginBase = pluginModel.getPluginBase();
                                String elementValue = requireBundle.getValue();
                                IPluginImport importNode = null;
                                if (pluginModel.getPluginFactory() instanceof BundlePluginModelBase) {
                                    importNode = ((BundlePluginModelBase)pluginModel.getPluginFactory()).createImport(elementValue);
                                }
                                String version = ((RequireBundleObject)element).getAttribute("bundle-version");
                                IManifestHeader header2 = bundleModel.getBundle().getManifestHeader("Require-Bundle");
                                int bundleManifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)((RequireBundleHeader)header2).getBundle());
                                boolean option = bundleManifestVersion > 1 ? "optional".equals(requireBundle.getDirective("resolution")) : "true".equals(requireBundle.getAttribute("optional"));
                                boolean bl = exported = bundleManifestVersion > 1 ? "reexport".equals(requireBundle.getDirective("visibility")) : "true".equals(requireBundle.getAttribute("reprovide"));
                                if (importNode != null) {
                                    importNode.setVersion(version);
                                    importNode.setOptional(option);
                                    importNode.setReexported(exported);
                                }
                                if (pluginBase instanceof BundlePluginBase && importNode != null) {
                                    ((BundlePluginBase)pluginBase).add(importNode);
                                }
                            }
                            if (element instanceof ExportPackageObject && (header = bundleModel.getBundle().getManifestHeader("Export-Package")) != null && header instanceof ExportPackageHeader) {
                                ((ExportPackageHeader)header).addPackage((PackageObject)element);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeRemove(IModelChangeProvider model, Object[] elements) {
        IPluginBase pluginBase = null;
        IBuild build = null;
        IBundleModel bundleModel = null;
        if (model instanceof IPluginModelBase) {
            pluginBase = ((IPluginModelBase)model).getPluginBase();
        } else if (model instanceof IBuildModel) {
            build = ((IBuildModel)model).getBuild();
        } else if (model instanceof IBundleModel) {
            bundleModel = (IBundleModel)model;
        }
        try {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IPluginImport) {
                    pluginBase.remove((IPluginImport)element);
                } else if (element instanceof IPluginLibrary) {
                    pluginBase.remove((IPluginLibrary)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    pluginBase.remove((IPluginExtensionPoint)element);
                } else if (element instanceof IPluginExtension) {
                    pluginBase.remove((IPluginExtension)element);
                } else {
                    Object object = element;
                    if (object instanceof IPluginElement) {
                        void e;
                        IPluginElement cfr_ignored_0 = (IPluginElement)object;
                        IPluginElement cfr_ignored_1 = (IPluginElement)object;
                        IBuildEntry parent = e.getParent();
                        if (parent instanceof PluginLibraryNode && e instanceof PluginElementNode) {
                            ((PluginLibraryNode)parent).removeContentFilter((PluginElementNode)e);
                        } else if (parent instanceof IPluginParent) {
                            ((IPluginParent)parent).remove((IPluginObject)e);
                        }
                    } else {
                        Object object2 = element;
                        if (object2 instanceof IBuildEntry) {
                            void e;
                            IBuildEntry cfr_ignored_2 = (IBuildEntry)object2;
                            IBuildEntry cfr_ignored_3 = (IBuildEntry)object2;
                            build.remove((IBuildEntry)e);
                        } else if (element instanceof BundleObject) {
                            IBaseModel aggModel;
                            IBaseModel iBaseModel;
                            IManifestHeader header;
                            if (element instanceof ImportPackageObject && (header = bundleModel.getBundle().getManifestHeader("Import-Package")) != null && header instanceof ImportPackageHeader) {
                                ((ImportPackageHeader)header).removePackage((PackageObject)element);
                            }
                            if (element instanceof RequireBundleObject && (iBaseModel = (aggModel = this.getEditor().getAggregateModel())) instanceof BundlePluginModel) {
                                void mod;
                                BundlePluginModel cfr_ignored_4 = (BundlePluginModel)iBaseModel;
                                BundlePluginModel cfr_ignored_5 = (BundlePluginModel)iBaseModel;
                                pluginBase = mod.getPluginBase();
                                IPluginImport[] imports = pluginBase.getImports();
                                IPluginImport currentImport = null;
                                IPluginImport[] iPluginImportArray = imports;
                                int n3 = imports.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IPluginImport pluginImport = iPluginImportArray[n4];
                                    String elementValue = ((RequireBundleObject)element).getValue();
                                    if (pluginImport.getId().equals(elementValue)) {
                                        currentImport = pluginImport;
                                        break;
                                    }
                                    ++n4;
                                }
                                IPluginImport[] plugins = new IPluginImport[]{currentImport};
                                if (pluginBase instanceof BundlePluginBase && currentImport != null) {
                                    ((BundlePluginBase)pluginBase).remove(plugins);
                                }
                            }
                            if (element instanceof ExportPackageObject && (header = bundleModel.getBundle().getManifestHeader("Export-Package")) != null && header instanceof ExportPackageHeader) {
                                ((ExportPackageHeader)header).removePackage((PackageObject)element);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeAttributeChange(AttributeChangedEvent e, boolean undo) {
        PluginElement element = (PluginElement)e.getChangedObjects()[0];
        PluginAttribute att = (PluginAttribute)e.getChangedAttribute();
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        try {
            if (undo) {
                element.setAttribute(att.getName(), oldValue.toString());
            } else {
                element.setAttribute(att.getName(), newValue.toString());
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        Object object = element;
        if (object instanceof PluginObject) {
            PluginObject pluginObject = (PluginObject)object;
            PluginObject cfr_ignored_0 = (PluginObject)object;
            try {
                void pobj;
                pobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else {
            Object object2 = element;
            if (object2 instanceof BuildObject) {
                BuildObject e = (BuildObject)object2;
                BuildObject cfr_ignored_1 = (BuildObject)object2;
                try {
                    void bobj;
                    bobj.restoreProperty(propertyName, oldValue, newValue);
                }
                catch (CoreException e2) {
                    PDEPlugin.logException(e2);
                }
            } else {
                Object object3;
                Object object4 = element;
                if (object4 instanceof PluginObjectNode) {
                    void node;
                    PluginObjectNode e2 = (PluginObjectNode)object4;
                    PluginObjectNode cfr_ignored_2 = (PluginObjectNode)object4;
                    String newString = newValue != null ? newValue.toString() : null;
                    node.setXMLAttribute(propertyName, newString);
                } else if (element instanceof BundleObject && (object3 = element) instanceof ImportPackageObject) {
                    void ipObj;
                    ImportPackageObject newString = (ImportPackageObject)object3;
                    ImportPackageObject cfr_ignored_3 = (ImportPackageObject)object3;
                    ipObj.restoreProperty(propertyName, oldValue, newValue);
                }
            }
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3) {
            IPluginObject obj;
            Object changedObject = event.getChangedObjects()[0];
            if (changedObject instanceof IPluginObject && !((obj = (IPluginObject)event.getChangedObjects()[0]) instanceof IPluginBase) && !obj.isInTheModel()) {
                return;
            }
            if (changedObject instanceof IBuildObject && !(obj = (IBuildObject)event.getChangedObjects()[0]).isInTheModel()) {
                return;
            }
        }
        super.modelChanged(event);
    }
}

