/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.product.BrandingPage;
import org.eclipse.pde.internal.ui.editor.product.ConfigurationPage;
import org.eclipse.pde.internal.ui.editor.product.CustomizationPage;
import org.eclipse.pde.internal.ui.editor.product.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.product.LaunchingPage;
import org.eclipse.pde.internal.ui.editor.product.LicensingPage;
import org.eclipse.pde.internal.ui.editor.product.OverviewPage;
import org.eclipse.pde.internal.ui.editor.product.ProductExportAction;
import org.eclipse.pde.internal.ui.editor.product.ProductInputContext;
import org.eclipse.pde.internal.ui.editor.product.ProductInputContextManager;
import org.eclipse.pde.internal.ui.editor.product.ProductLauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.product.ProductOutlinePage;
import org.eclipse.pde.internal.ui.editor.product.ProductSourcePage;
import org.eclipse.pde.internal.ui.editor.product.ProductValidateAction;
import org.eclipse.pde.internal.ui.editor.product.SplashPage;
import org.eclipse.pde.internal.ui.editor.product.UpdatesPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class ProductEditor
extends PDELauncherFormEditor {
    private ProductExportAction fExportAction;
    private ILauncherFormPageHelper fLauncherHelper;

    @Override
    protected String getEditorID() {
        return "org.eclipse.pde.ui.productEditor";
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public String getContextIDForSaveAs() {
        return "product-context";
    }

    @Override
    protected InputContextManager createInputContextManager() {
        return new ProductInputContextManager(this);
    }

    @Override
    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        manager.putContext((IEditorInput)input, new ProductInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(input.getFile());
    }

    @Override
    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        File file = new File(input.getURI());
        String name = file.getName();
        if (name.endsWith(".product")) {
            try {
                IFileStore store = EFS.getStore((URI)file.toURI());
                FileStoreEditorInput in = new FileStoreEditorInput(store);
                manager.putContext((IEditorInput)in, new ProductInputContext(this, (IEditorInput)in, true));
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input.getName().endsWith(".product")) {
            manager.putContext((IEditorInput)input, new ProductInputContext(this, (IEditorInput)input, true));
        }
    }

    @Override
    protected ISortableContentOutlinePage createContentOutline() {
        return new ProductOutlinePage(this);
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new ProductSourcePage(editor, title, name);
    }

    @Override
    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("product-context");
    }

    @Override
    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this));
            this.addPage((IFormPage)new DependenciesPage(this, this.getProductType()));
            this.addPage((IFormPage)new ConfigurationPage(this, false));
            this.addPage((IFormPage)new LaunchingPage(this));
            this.addPage((IFormPage)new SplashPage(this));
            this.addPage((IFormPage)new BrandingPage(this));
            this.addPage((IFormPage)new CustomizationPage(this));
            this.addPage((IFormPage)new LicensingPage(this));
            this.addPage((IFormPage)new UpdatesPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("product-context");
    }

    public void updateConfigurationPage() {
        try {
            this.removePage(1);
            this.addPage(1, (IFormPage)new DependenciesPage(this, this.getProductType()));
        }
        catch (PartInitException partInitException) {}
    }

    public IProduct.ProductType getProductType() {
        IBaseModel model = this.getAggregateModel();
        return model != null ? ((IProductModel)model).getProduct().getType() : null;
    }

    @Override
    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    @Override
    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    @Override
    public void monitoredFileAdded(IFile monitoredFile) {
    }

    @Override
    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void contributeToToolbar(IToolBarManager manager) {
        this.contributeLaunchersToToolbar(manager);
        manager.add((IAction)this.getExportAction());
        IBaseModel iBaseModel = this.getAggregateModel();
        if (iBaseModel instanceof IProductModel) {
            void productModel;
            IProductModel iProductModel = (IProductModel)iBaseModel;
            IProductModel cfr_ignored_0 = (IProductModel)iBaseModel;
            productModel.addModelChangedListener(e -> {
                if ("type".equals(e.getChangedProperty())) {
                    this.setExportActionState();
                }
            });
            manager.add((IAction)new ProductValidateAction(productModel.getProduct()));
        }
    }

    private ProductExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new ProductExportAction(this);
            this.fExportAction.setImageDescriptor(PDEPluginImages.DESC_EXPORT_PRODUCT_TOOL);
            this.setExportActionState();
        }
        return this.fExportAction;
    }

    /*
     * WARNING - void declaration
     */
    private void setExportActionState() {
        IBaseModel iBaseModel = this.getAggregateModel();
        if (iBaseModel instanceof IProductModel) {
            void productModel;
            IProductModel iProductModel = (IProductModel)iBaseModel;
            IProductModel cfr_ignored_0 = (IProductModel)iBaseModel;
            boolean isMixed = productModel.getProduct().getType() == IProduct.ProductType.MIXED;
            this.fExportAction.setEnabled(!isMixed);
            this.fExportAction.setToolTipText(isMixed ? PDEUIMessages.ProductEditor_exportTooltip_mixed : PDEUIMessages.ProductEditor_exportTooltip);
        }
    }

    @Override
    protected ILauncherFormPageHelper getLauncherHelper() {
        if (this.fLauncherHelper == null) {
            this.fLauncherHelper = new ProductLauncherFormPageHelper(this);
        }
        return this.fLauncherHelper;
    }
}

