/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.Stack;
import org.eclipse.pde.internal.ui.wizards.templates.PreprocessorParser;
import org.eclipse.pde.ui.templates.IVariableProvider;

public class ControlStack {
    private final Stack<Entry> stack = new Stack();
    private final PreprocessorParser parser = new PreprocessorParser();

    public void setValueProvider(IVariableProvider provider) {
        this.parser.setVariableProvider(provider);
    }

    public void processLine(String line) {
        if (line.startsWith("if")) {
            String expression = line.substring(2).trim();
            boolean result = false;
            try {
                result = this.parser.parseAndEvaluate(expression);
            }
            catch (Exception exception) {}
            Entry entry = new Entry();
            entry.value = result;
            this.stack.push(entry);
        } else if (line.startsWith("else")) {
            if (!this.stack.isEmpty()) {
                Entry entry = this.stack.peek();
                entry.value = !entry.value;
            }
        } else if (line.startsWith("endif") && !this.stack.isEmpty()) {
            this.stack.pop();
        }
    }

    public boolean getCurrentState() {
        if (this.stack.isEmpty()) {
            return true;
        }
        for (Entry entry : this.stack) {
            if (entry.value) continue;
            return false;
        }
        return true;
    }

    static class Entry {
        boolean value;

        Entry() {
        }
    }
}

