/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.style;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

public class XMLTextAttributeMap {
    private static HashMap<String, TextAttribute> textAttributeMap = new HashMap();
    private static XMLTextAttributeMap xmlTextAttributeMap = new XMLTextAttributeMap();
    private static IPreferenceStore xmlPreferenceStore;

    private static IPreferenceStore getXMLPreferenceStore() {
        return xmlPreferenceStore;
    }

    private XMLTextAttributeMap() {
        xmlPreferenceStore = XMLUIPlugin.getDefault().getPreferenceStore();
        this.addXMLTextAttribute("tagName");
        this.addXMLTextAttribute("tagBorder");
        this.addXMLTextAttribute("tagAttributeName");
        this.addXMLTextAttribute("tagAttributeValue");
        this.addXMLTextAttribute("tagAttributeEquals");
        this.addXMLTextAttribute("commentBorder");
        this.addXMLTextAttribute("commentText");
        this.addXMLTextAttribute("cdataBorder");
        this.addXMLTextAttribute("cdataText");
        this.addXMLTextAttribute("declBoder");
        this.addXMLTextAttribute("doctypeExternalId");
        this.addXMLTextAttribute("doctypeExternalPubref");
        this.addXMLTextAttribute("doctypeExtrenalSysref");
        this.addXMLTextAttribute("doctypeName");
        this.addXMLTextAttribute("piContent");
        this.addXMLTextAttribute("piBorder");
        this.addXMLTextAttribute("xmlContent");
        this.addXMLTextAttribute("entityReference");
    }

    public static XMLTextAttributeMap getInstance() {
        return xmlTextAttributeMap;
    }

    public Map<String, TextAttribute> getTextAttributeMap() {
        return textAttributeMap;
    }

    private void addXMLTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (XMLTextAttributeMap.getXMLPreferenceStore() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = XMLTextAttributeMap.getXMLPreferenceStore().getString(colorKey)))) != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            boolean italic = Boolean.valueOf(stylePrefs[3]);
            boolean strikethrough = Boolean.valueOf(stylePrefs[4]);
            boolean underline = Boolean.valueOf(stylePrefs[5]);
            int style = 0;
            if (bold) {
                style |= 1;
            }
            if (italic) {
                style |= 2;
            }
            if (strikethrough) {
                style |= 0x20000000;
            }
            if (underline) {
                style |= 0x40000000;
            }
            TextAttribute createTextAttribute = this.createTextAttribute(foreground, background, style);
            textAttributeMap.put(colorKey, createTextAttribute);
        }
    }

    protected TextAttribute createTextAttribute(RGB foreground, RGB background, int style) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, style);
    }
}

