/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.workingsets.ScriptWorkingSetPageContentProvider;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.StyledDecoratingModelLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class ScriptWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.ScriptWorkingSetPage_title;
    private static final String PAGE_ID = "ScriptWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;

    public ScriptWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, DLTKPluginImages.DESC_WIZBAN_SCRIPT_WORKINGSET);
        this.setDescription(WorkingSetMessages.ScriptWorkingSetPage_workingSet_description);
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.ScriptWorkingSetPage_workingSet_name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(e -> this.validateInput());
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.ScriptWorkingSetPage_workingSet_content);
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new ScriptWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider fScriptElementLabelProvider = new AppearanceAwareLabelProvider(564186904002603L, 3, DLTKUIPlugin.getDefault().getPreferenceStore());
        this.fTree.setLabelProvider((IBaseLabelProvider)new StyledDecoratingModelLabelProvider(fScriptElementLabelProvider));
        this.fTree.setComparator((ViewerComparator)new ModelElementSorter());
        if (DLTKCore.DEBUG) {
            System.err.println("Add empty inner package filter support here...");
        }
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.fTree.addCheckStateListener(event -> this.handleCheckStateChange(event));
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!ScriptWorkingSetPage.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)ScriptWorkingSetPage.this.getShell().getDisplay(), () -> ScriptWorkingSetPage.this.setSubtreeChecked(element, ScriptWorkingSetPage.this.fTree.getChecked(element), false));
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(WorkingSetMessages.ScriptWorkingSetPage_selectAll_label);
        selectAllButton.setToolTipText(WorkingSetMessages.ScriptWorkingSetPage_selectAll_toolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScriptWorkingSetPage.this.fTree.setCheckedElements(ScriptWorkingSetPage.this.fTreeContentProvider.getElements(ScriptWorkingSetPage.this.fTree.getInput()));
                ScriptWorkingSetPage.this.validateInput();
            }
        });
        selectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(WorkingSetMessages.ScriptWorkingSetPage_deselectAll_label);
        deselectAllButton.setToolTipText(WorkingSetMessages.ScriptWorkingSetPage_deselectAll_toolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScriptWorkingSetPage.this.fTree.setCheckedElements(new Object[0]);
                ScriptWorkingSetPage.this.validateInput();
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(deselectAllButton);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(elements, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            ArrayList<IProject> closedWithChildren = new ArrayList<IProject>(elements.size());
            int i = 0;
            while (i < oldItems.length) {
                IProject project;
                IResource oldResource = null;
                oldResource = oldItems[i] instanceof IResource ? (IResource)oldItems[i] : (IResource)oldItems[i].getAdapter(IResource.class);
                if (oldResource != null && !oldResource.isAccessible() && (elements.contains(project = oldResource.getProject()) || closedWithChildren.contains(project))) {
                    elements.add(oldItems[i]);
                    elements.remove(project);
                    closedWithChildren.add(project);
                }
                ++i;
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.ScriptWorkingSetPage_warning_nameWhitespace;
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.ScriptWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.ScriptWorkingSetPage_warning_workingSetExists;
                }
                ++i;
            }
        }
        if (!this.hasCheckedElement()) {
            infoMessage = WorkingSetMessages.ScriptWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] items = this.fTree.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.fTree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
            } else if (this.fTree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    void handleCheckStateChange(CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            IAdaptable element = (IAdaptable)event.getElement();
            boolean state = event.getChecked();
            this.fTree.setGrayed((Object)element, false);
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, state);
            }
            this.updateParentState(element, state);
            this.validateInput();
        });
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IContainer container = (IContainer)((IAdaptable)parent).getAdapter(IContainer.class);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(Object child, boolean baseChildState) {
        IResource resource;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable && (resource = (IResource)((IAdaptable)child).getAdapter(IResource.class)) != null && !resource.isAccessible()) {
            return;
        }
        Object parent = this.fTreeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.fTree.getChecked(children[i]) != baseChildState || this.fTree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.fTree.setGrayed(parent, !allSameState);
        this.fTree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            Object[] elements;
            if (this.fWorkingSet == null) {
                IWorkbenchPage page = DLTKUIPlugin.getActivePage();
                if (page == null) {
                    return;
                }
                IWorkbenchPart part = DLTKUIPlugin.getActivePage().getActivePart();
                if (part == null) {
                    return;
                }
                try {
                    elements = SelectionConverter.getStructuredSelection(part).toArray();
                    int i1 = 0;
                    while (i1 < elements.length) {
                        IModelElement je;
                        if (elements[i1] instanceof IResource && (je = (IModelElement)((IResource)elements[i1]).getAdapter(IModelElement.class)) != null && je.exists() && je.getScriptProject().isOnBuildpath((IResource)elements[i1])) {
                            elements[i1] = je;
                        }
                        ++i1;
                    }
                }
                catch (ModelException e) {
                    return;
                }
            } else {
                elements = this.fWorkingSet.getElements();
            }
            int i2 = 0;
            while (i2 < elements.length) {
                IScriptProject jProject;
                IProject project;
                IAdaptable element1 = elements[i2];
                if (element1 instanceof IResource && !(project = ((IResource)element1).getProject()).isAccessible()) {
                    elements[i2] = project;
                }
                if (element1 instanceof IModelElement && (jProject = ((IModelElement)element1).getScriptProject()) != null && !jProject.getProject().isAccessible()) {
                    elements[i2] = jProject.getProject();
                }
                ++i2;
            }
            this.fTree.setCheckedElements(elements);
            int i3 = 0;
            while (i3 < elements.length) {
                Object element2 = elements[i3];
                if (this.isExpandable(element2)) {
                    this.setSubtreeChecked(element2, true, true);
                }
                this.updateParentState(element2, true);
                ++i3;
            }
        });
    }

    private boolean isExpandable(Object element) {
        return element instanceof IScriptProject || element instanceof IProjectFragment || element instanceof IScriptFolder || element instanceof IScriptModel || element instanceof IContainer;
    }
}

