/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.preferences.IFieldValidator;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.preferences.ITextConverter;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ControlBindingManager<KEY> {
    final IStatusChangeListener changeListener;
    private Map<Button, KEY> checkBoxControls;
    private Map<Combo, KEY> comboControls;
    private final Map<Combo, IComboSelectedValueProvider> comboValueProviders = new IdentityHashMap<Combo, IComboSelectedValueProvider>();
    private DependencyManager dependencyManager;
    final IPreferenceDelegate<KEY> preferenceDelegate;
    private Map<Button, KEY> radioControls;
    private Map<Text, KEY> textControls;
    private final Map<Text, ITextConverter> textTransformers = new HashMap<Text, ITextConverter>();
    private ValidatorManager validatorManager;
    public static final DependencyMode DEPENDENCY_INVERSE_SELECTION = new DependencyMode();

    public ControlBindingManager(IPreferenceDelegate<KEY> delegate, IStatusChangeListener listener) {
        this.checkBoxControls = new HashMap<Button, KEY>();
        this.comboControls = new HashMap<Combo, KEY>();
        this.textControls = new HashMap<Text, KEY>();
        this.radioControls = new HashMap<Button, KEY>();
        this.validatorManager = new ValidatorManager();
        this.dependencyManager = new DependencyManager();
        this.changeListener = listener;
        this.preferenceDelegate = delegate;
    }

    public void bindControl(final Combo combo, KEY key) {
        this.bindControl(combo, key, new IComboSelectedValueProvider(){

            @Override
            public String getValueAt(int index) {
                return index >= 0 && index < combo.getItemCount() ? combo.getItem(index) : null;
            }

            @Override
            public int indexOf(String value) {
                String[] items = combo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(value)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public void bindControl(Combo combo, KEY key, final String[] itemValues) {
        this.bindControl(combo, key, new IComboSelectedValueProvider(){

            @Override
            public String getValueAt(int index) {
                return itemValues[index];
            }

            @Override
            public int indexOf(String value) {
                int i = 0;
                while (i < itemValues.length) {
                    if (itemValues[i].equals(value)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public void bindControl(final Combo combo, final KEY key, final IComboSelectedValueProvider itemValueProvider) {
        if (key != null) {
            this.comboControls.put(combo, key);
        }
        this.comboValueProviders.put(combo, itemValueProvider);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                ControlBindingManager.this.preferenceDelegate.setString(key, itemValueProvider.getValueAt(index));
                ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
            }
        });
    }

    public void bindControl(final Button button, final KEY key, Control[] slaves) {
        if (key != null) {
            this.checkBoxControls.put(button, key);
        }
        this.createDependency(button, slaves);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ControlBindingManager.this.preferenceDelegate.setBoolean(key, state);
                ControlBindingManager.this.updateStatus(StatusInfo.OK_STATUS);
            }
        });
    }

    public void bindControl(Text text, KEY key, IFieldValidator validator) {
        this.bindControl(text, key, validator, null);
    }

    public void bindControl(Text text, KEY key, IFieldValidator validator, ITextConverter transformer) {
        if (key != null) {
            if (this.textControls.containsKey(key)) {
                IllegalArgumentException error = new IllegalArgumentException("Duplicate control " + String.valueOf(key));
                DLTKUIPlugin.log(error);
                if (DLTKCore.DEBUG) {
                    throw error;
                }
            }
            this.textControls.put(text, key);
            if (transformer != null) {
                this.textTransformers.put(text, transformer);
            }
        }
        if (validator != null) {
            this.validatorManager.registerValidator(text, validator);
        }
        text.addModifyListener(e -> {
            IStatus status = this.validateText(text);
            if (key != null && status.getSeverity() != 4) {
                String value = text.getText();
                if (transformer != null) {
                    value = transformer.convertInput(value);
                }
                this.preferenceDelegate.setString(key, value);
            }
            this.updateStatus(status);
        });
    }

    public void bindRadioControl(Button button, final KEY key, final Object enable, Control[] dependencies) {
        if (key != null) {
            this.radioControls.put(button, key);
        }
        this.createDependency(button, dependencies);
        button.setData((Object)String.valueOf(enable));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = String.valueOf(enable);
                ControlBindingManager.this.preferenceDelegate.setString(key, value);
            }
        });
    }

    public void createDependency(Button button, Control[] dependencies) {
        this.createDependency(button, dependencies, null);
    }

    public void createDependency(Button button, Control[] dependencies, DependencyMode mode) {
        if (dependencies != null) {
            this.dependencyManager.createDependency(button, dependencies, mode);
        }
    }

    public IStatus getStatus() {
        IStatus status = StatusInfo.OK_STATUS;
        Iterator<Text> iter = this.textControls.keySet().iterator();
        while (iter.hasNext()) {
            IStatus s = this.validateText(iter.next());
            status = StatusUtil.getMoreSevere(s, status);
        }
        return status;
    }

    public void initialize() {
        this.initTextControls();
        this.initCheckBoxes();
        this.initRadioControls();
        this.initCombos();
        this.dependencyManager.initialize();
    }

    protected void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            Iterator<Text> iter = this.textControls.keySet().iterator();
            while (iter.hasNext()) {
                IStatus s = this.validateText(iter.next());
                status = StatusUtil.getMoreSevere(s, status);
            }
        }
        this.changeListener.statusChanged(status);
    }

    private void initCheckBoxes() {
        for (Button button : this.checkBoxControls.keySet()) {
            KEY key = this.checkBoxControls.get(button);
            button.setSelection(this.preferenceDelegate.getBoolean(key));
        }
    }

    private void initCombos() {
        for (Map.Entry<Combo, KEY> entry : this.comboControls.entrySet()) {
            Combo combo = entry.getKey();
            KEY key = entry.getValue();
            String value = this.preferenceDelegate.getString(key);
            IComboSelectedValueProvider valueProvider = this.comboValueProviders.get(combo);
            if (valueProvider == null) continue;
            int index = valueProvider.indexOf(value);
            if (index >= 0) {
                combo.select(index);
                continue;
            }
            combo.select(0);
        }
    }

    private void initRadioControls() {
        for (Button button : this.radioControls.keySet()) {
            KEY key = this.radioControls.get(button);
            String enable = (String)button.getData();
            String value = this.preferenceDelegate.getString(key);
            if (enable != null && enable.equals(value)) {
                button.setSelection(true);
                continue;
            }
            button.setSelection(false);
        }
    }

    private void initTextControls() {
        for (Text text : this.textControls.keySet()) {
            KEY key = this.textControls.get(text);
            String value = this.preferenceDelegate.getString(key);
            ITextConverter textTransformer = this.textTransformers.get(text);
            if (textTransformer != null) {
                value = textTransformer.convertPreference(value);
            }
            text.setText(value);
        }
    }

    private IStatus validateText(Text text) {
        IFieldValidator validator = this.validatorManager.getValidator((Control)text);
        if (validator != null && text.isEnabled()) {
            return validator.validate(text.getText());
        }
        return StatusInfo.OK_STATUS;
    }

    class DependencyManager {
        private List<SelectionListener> masterSlaveListeners = new ArrayList<SelectionListener>();

        DependencyManager() {
        }

        public void createDependency(final Button master, final Control[] slaves, final DependencyMode mode) {
            SelectionListener listener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean state = master.getSelection();
                    if (mode == DEPENDENCY_INVERSE_SELECTION) {
                        state = !state;
                    }
                    int i = 0;
                    while (i < slaves.length) {
                        slaves[i].setEnabled(state);
                        ++i;
                    }
                    ((DependencyManager)DependencyManager.this).ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            master.addSelectionListener(listener);
            this.masterSlaveListeners.add(listener);
        }

        public void initialize() {
            Iterator<SelectionListener> it = this.masterSlaveListeners.iterator();
            while (it.hasNext()) {
                it.next().widgetSelected(null);
            }
        }
    }

    public static class DependencyMode {
    }

    public static interface IComboSelectedValueProvider {
        public String getValueAt(int var1);

        public int indexOf(String var1);
    }

    static class ValidatorManager
    extends HashMap<Control, IFieldValidator> {
        ValidatorManager() {
        }

        public IFieldValidator getValidator(Control control) {
            return (IFieldValidator)this.get(control);
        }

        public void registerValidator(Text text, IFieldValidator validator) {
            this.put(text, validator);
        }

        public void unregisterValidator(Text text) {
            this.remove(text);
        }
    }
}

