/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.util.IProgressListener;

public class ProgressMonitorWrapper
implements IProgressListener {
    IProgressMonitor delegate;
    boolean isCancelled;
    long lastCheck;

    public ProgressMonitorWrapper(IProgressMonitor monitor) {
        this.delegate = monitor;
        this.isCancelled = false;
        this.lastCheck = System.currentTimeMillis();
    }

    public void beginTask(String name, int totalWork) {
        this.delegate.beginTask(name, totalWork);
    }

    public void done() {
        this.delegate.done();
    }

    public boolean isCanceled() {
        long now = System.currentTimeMillis();
        if (now > this.lastCheck) {
            this.lastCheck = now + 2000L;
            this.isCancelled = this.delegate.isCanceled();
            return this.isCancelled;
        }
        return this.isCancelled;
    }

    public void setCanceled(boolean value) {
        this.delegate.setCanceled(value);
    }

    public void subTask(String name) {
        this.delegate.subTask(name);
    }

    public void worked(int work) {
        this.delegate.worked(work);
    }

    public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
        ProgressMonitorWrapper.doSendUserMessage(severity, message, exception);
    }

    static void doSendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
        int eclipseSeverity = 0;
        switch (severity) {
            case INFO: {
                eclipseSeverity = 1;
                break;
            }
            case WARNING: {
                eclipseSeverity = 2;
                break;
            }
            case ERROR: {
                eclipseSeverity = 4;
            }
        }
        MemoryAnalyserPlugin.log((IStatus)new Status(eclipseSeverity, "org.eclipse.mat.ui", message, exception));
    }
}

