/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.model.ITestElement;

public final class Status {
    public static final Status RUNNING_ERROR = new Status("RUNNING_ERROR");
    public static final Status RUNNING_FAILURE = new Status("RUNNING_FAILURE");
    public static final Status RUNNING = new Status("RUNNING");
    public static final Status ERROR = new Status("ERROR");
    public static final Status FAILURE = new Status("FAILURE");
    public static final Status OK = new Status("OK");
    public static final Status NOT_RUN = new Status("NOT_RUN");
    private static final Status[] OLD_CODE = new Status[]{OK, ERROR, FAILURE};
    private final String fName;

    private Status(String name) {
        this.fName = name;
    }

    public String toString() {
        return this.fName;
    }

    public boolean isOK() {
        return this == OK || this == RUNNING || this == NOT_RUN;
    }

    public boolean isFailure() {
        return this == FAILURE || this == RUNNING_FAILURE;
    }

    public boolean isError() {
        return this == ERROR || this == RUNNING_ERROR;
    }

    public boolean isErrorOrFailure() {
        return this.isError() || this.isFailure();
    }

    public boolean isNotRun() {
        return this == NOT_RUN;
    }

    public boolean isRunning() {
        return this == RUNNING || this == RUNNING_FAILURE || this == RUNNING_ERROR;
    }

    public boolean isDone() {
        return this == OK || this == FAILURE || this == ERROR;
    }

    public static Status convert(int oldStatus) {
        return OLD_CODE[oldStatus];
    }

    public ITestElement.Result convertToResult() {
        if (this.isNotRun()) {
            return ITestElement.Result.UNDEFINED;
        }
        if (this.isError()) {
            return ITestElement.Result.ERROR;
        }
        if (this.isFailure()) {
            return ITestElement.Result.FAILURE;
        }
        if (this.isRunning()) {
            return ITestElement.Result.UNDEFINED;
        }
        return ITestElement.Result.OK;
    }

    public ProgressState convertToProgressState() {
        if (this.isRunning()) {
            return ProgressState.RUNNING;
        }
        if (this.isDone()) {
            return ProgressState.COMPLETED;
        }
        return ProgressState.NOT_STARTED;
    }

    public static Status fromResult(ITestElement.Result status) {
        switch (status) {
            case ERROR: {
                return ERROR;
            }
            case FAILURE: {
                return FAILURE;
            }
            case OK: {
                return OK;
            }
            case IGNORED: {
                return OK;
            }
            case UNDEFINED: {
                return NOT_RUN;
            }
        }
        return NOT_RUN;
    }
}

