/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui.history;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.junitXmlReport.HistoryEntryHandler;
import org.eclipse.unittest.internal.junitXmlReport.TestRunHandler;
import org.eclipse.unittest.internal.junitXmlReport.TestRunSessionSerializer;
import org.eclipse.unittest.internal.model.ITestSessionListener;
import org.eclipse.unittest.internal.model.ModelMessages;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.ui.BasicElementLabels;
import org.eclipse.unittest.internal.ui.history.History;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class HistoryItem {
    private File historyFile;
    private TestRunSession session;
    private String name;
    private Instant startTime;
    private int failuresAndErrors;

    public HistoryItem(TestRunSession session) {
        this.session = session;
        this.name = session.getTestRunName();
        this.startTime = session.getStartTime();
        this.failuresAndErrors = session.getCurrentErrorCount() + session.getCurrentFailureCount();
        session.addTestSessionListener(new ITestSessionListener(){

            @Override
            public void testStarted(ITestCaseElement testCaseElement) {
            }

            @Override
            public void testFailed(ITestElement testElement, ITestElement.Result status, ITestElement.FailureTrace trace) {
            }

            @Override
            public void testEnded(ITestCaseElement testCaseElement) {
            }

            @Override
            public void testAdded(ITestElement testElement) {
            }

            @Override
            public void sessionStarted() {
                HistoryItem.this.getFile();
            }

            @Override
            public void sessionCompleted(Duration duration) {
                try {
                    HistoryItem.this.storeSessionToFile(HistoryItem.this.getFile());
                }
                catch (CoreException e) {
                    UnitTestPlugin.log(e);
                }
            }

            @Override
            public void sessionAborted(Duration duration) {
                this.sessionCompleted(duration);
            }

            @Override
            public void runningBegins() {
            }
        });
    }

    public HistoryItem(File file) {
        this.historyFile = file;
        try {
            SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
            HistoryEntryHandler handler = new HistoryEntryHandler();
            parser.parse(this.getFile(), (DefaultHandler)handler);
            this.name = handler.getName();
            this.startTime = handler.getStartTime();
            this.failuresAndErrors = handler.getFailuresAndErrors();
        }
        catch (Exception e) {
            UnitTestPlugin.log(e);
        }
    }

    public TestRunSession reloadTestRunSession() throws CoreException {
        if (this.session == null && this.getFile() != null) {
            try {
                SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
                TestRunHandler handler = new TestRunHandler((IProgressMonitor)new NullProgressMonitor());
                parser.parse(this.getFile(), (DefaultHandler)handler);
                this.session = handler.getTestRunSession();
            }
            catch (Exception e) {
                HistoryItem.throwImportError(this.getFile(), e);
            }
        }
        return this.session;
    }

    public Optional<TestRunSession> getCurrentTestRunSession() {
        return Optional.ofNullable(this.session);
    }

    public void removeSwapFile() throws IOException {
        if (this.historyFile != null && this.historyFile.exists()) {
            Files.delete(this.historyFile.toPath());
        }
    }

    void storeSessionToFile(File target) throws TransformerFactoryConfigurationError, CoreException {
        if (this.session == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(target);){
                Transformer transformer = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE().newTransformer();
                InputSource inputSource = new InputSource();
                SAXSource source = new SAXSource(new TestRunSessionSerializer(this.session), inputSource);
                StreamResult result = new StreamResult(out);
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                transformer.transform(source, result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            HistoryItem.throwExportError(target, e);
        }
    }

    public File getFile() {
        if (this.historyFile == null) {
            File historyDir = History.INSTANCE.getDirectory();
            String isoTime = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS").format(new Date(this.getStartDate().toEpochMilli()));
            String swapFileName = this.session.getTestRunName() + "@" + isoTime + ".xml";
            this.historyFile = new File(historyDir, swapFileName);
        }
        return this.historyFile;
    }

    public void swapOut() throws CoreException {
        if (this.session != null && this.session.isStopped()) {
            this.storeSessionToFile(this.getFile());
            this.session = null;
        }
    }

    public String getName() {
        if (this.session != null) {
            return this.session.getTestRunName();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.getFile().getName();
    }

    public Instant getStartDate() {
        if (this.session != null) {
            this.startTime = this.session.getStartTime();
        }
        if (this.startTime != null) {
            return this.startTime;
        }
        return Instant.now();
    }

    public int getFailureCount() {
        if (this.session != null) {
            return this.session.getCurrentErrorCount() + this.session.getCurrentFailureCount();
        }
        return this.failuresAndErrors;
    }

    private static void throwExportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.unittest.ui", MessageFormat.format(ModelMessages.UnitTestModel_could_not_write, BasicElementLabels.getPathLabel(file)), (Throwable)e));
    }

    private static void throwImportError(File file, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.unittest.ui", MessageFormat.format(ModelMessages.UnitTestModel_could_not_read, BasicElementLabels.getPathLabel(file)), (Throwable)e));
    }

    public Long getSizeOnDisk() {
        File file = this.getFile();
        if (file != null && file.isFile()) {
            return file.length();
        }
        return null;
    }
}

