/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.extensions.CategoriesExtensionPointManager;
import org.eclipse.tcf.te.ui.views.handler.OpenEditorHandler;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ViewsUtil {
    public static IWorkbenchPart getPart(final String id) {
        Assert.isNotNull((Object)id);
        final AtomicReference<Object> part = new AtomicReference<Object>(null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    part.set(reference != null ? reference.getPart(false) : null);
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        }
        return part.get();
    }

    public static void show(final String id) {
        Assert.isNotNull((Object)id);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void refresh(final String id) {
        Assert.isNotNull((Object)id);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    CommonViewer viewer;
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    IWorkbenchPart part = reference != null ? reference.getPart(false) : null;
                    CommonViewer commonViewer = viewer = part instanceof CommonNavigator ? ((CommonNavigator)part).getCommonViewer() : null;
                    if (viewer == null) {
                        Viewer viewer2 = viewer = part != null ? (Viewer)part.getAdapter(Viewer.class) : null;
                    }
                    if (viewer != null) {
                        viewer.refresh();
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void refresh(final String id, final Object element) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)element);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    CommonViewer viewer;
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    IWorkbenchPart part = reference != null ? reference.getPart(false) : null;
                    CommonViewer commonViewer = viewer = part instanceof CommonNavigator ? ((CommonNavigator)part).getCommonViewer() : null;
                    if (viewer == null) {
                        Viewer viewer2 = viewer = part != null ? (Viewer)part.getAdapter(Viewer.class) : null;
                    }
                    if (viewer instanceof StructuredViewer) {
                        ((StructuredViewer)viewer).refresh(element, true);
                    } else if (viewer != null) {
                        viewer.refresh();
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void setSelection(final String id, final ISelection selection) {
        Assert.isNotNull((Object)id);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    ISelectionProvider selectionProvider;
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    IWorkbenchPart part = reference != null ? reference.getPart(false) : null;
                    ISelectionProvider iSelectionProvider = selectionProvider = part != null && part.getSite() != null ? part.getSite().getSelectionProvider() : null;
                    if (selectionProvider != null) {
                        selectionProvider.setSelection(selection);
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void openEditor(final ISelection selection) {
        Assert.isNotNull((Object)selection);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Assert.isNotNull((Object)window);
                OpenEditorHandler.openEditorOnSelection(window, selection);
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void reopenEditor(final IEditorPart editor, final String pageId, final boolean save) {
        Assert.isNotNull((Object)editor);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Assert.isNotNull((Object)window);
                IWorkbenchPage page = window.getActivePage();
                Assert.isNotNull((Object)page);
                IEditorInput input = editor.getEditorInput();
                page.closeEditor(editor, save);
                try {
                    IEditorPart newEditor = page.openEditor(input, "org.eclipse.tcf.te.ui.views.Editor");
                    if (newEditor instanceof FormEditor && pageId != null) {
                        ((FormEditor)newEditor).setActivePage(pageId);
                    }
                }
                catch (PartInitException e) {
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.ViewsUtil_reopen_error, (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static void goInto(String id, String categoryId) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)categoryId);
        ICategory category = CategoriesExtensionPointManager.getInstance().getCategory(categoryId, false);
        if (category != null) {
            ViewsUtil.goInto(id, category);
        }
    }

    public static void goInto(String id, Object node) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)node);
        ViewsUtil.goInto(id, (ISelection)new StructuredSelection(node));
    }

    public static void goInto(final String id, ISelection selection) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)selection);
        ViewsUtil.setSelection(id, selection);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    IAction action;
                    IViewReference reference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(id);
                    IWorkbenchPart part = reference != null ? reference.getPart(false) : null;
                    IActionBars actionBars = part != null && part.getSite() instanceof IViewSite ? ((IViewSite)part.getSite()).getActionBars() : null;
                    IAction iAction = action = actionBars != null ? actionBars.getGlobalActionHandler("goInto") : null;
                    if (action != null) {
                        action.run();
                    }
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }
}

