/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import java.io.Serializable;
import java.util.Objects;

public final class FeatureSet
implements Serializable {
    private final int number;
    private final boolean unsupported;
    private final boolean es6Modules;
    private final boolean typeScript;
    public static final FeatureSet ES3 = new FeatureSet(3, false, false, false);
    public static final FeatureSet ES5 = new FeatureSet(5, false, false, false);
    public static final FeatureSet ES6_IMPL = new FeatureSet(6, false, false, false);
    public static final FeatureSet ES6 = new FeatureSet(6, true, false, false);
    public static final FeatureSet ES6_MODULES = new FeatureSet(6, true, true, false);
    public static final FeatureSet TYPESCRIPT = new FeatureSet(6, true, false, true);

    private FeatureSet(int number, boolean unsupported, boolean es6Modules, boolean typeScript) {
        this.number = number;
        this.unsupported = unsupported;
        this.es6Modules = es6Modules;
        this.typeScript = typeScript;
    }

    public String version() {
        if (this.typeScript) {
            return "ts";
        }
        if (this.unsupported || this.es6Modules) {
            return "es6";
        }
        if (this.number > 5) {
            return "es6-impl";
        }
        if (this.number > 3) {
            return "es5";
        }
        return "es3";
    }

    public boolean hasEs6Modules() {
        return this.es6Modules;
    }

    public boolean isTypeScript() {
        return this.typeScript;
    }

    public FeatureSet require(FeatureSet other) {
        if (other.number > this.number || other.unsupported && !this.unsupported || other.es6Modules && !this.es6Modules || other.typeScript && !this.typeScript) {
            return new FeatureSet(Math.max(this.number, other.number), this.unsupported || other.unsupported, this.es6Modules || other.es6Modules, this.typeScript || other.typeScript);
        }
        return this;
    }

    public FeatureSet require(Feature feature) {
        return this.require(feature.features);
    }

    public boolean equals(Object other) {
        return other instanceof FeatureSet && ((FeatureSet)other).number == this.number && ((FeatureSet)other).unsupported == this.unsupported && ((FeatureSet)other).es6Modules == this.es6Modules && ((FeatureSet)other).typeScript == this.typeScript;
    }

    public int hashCode() {
        return Objects.hash(this.number, this.unsupported, this.es6Modules, this.typeScript);
    }

    public String toString() {
        return "FeatureSet{number=" + this.number + (this.unsupported ? ", unsupported" : "") + (this.es6Modules ? ", es6Modules" : "") + (this.typeScript ? ", typeScript" : "") + "}";
    }

    public String toLanguageModeString() {
        return "ECMASCRIPT" + this.number;
    }

    public static enum Feature {
        ES3_KEYWORDS_AS_IDENTIFIERS("ES3 keywords as identifiers", ES5),
        GETTER("getters", ES5),
        KEYWORDS_AS_PROPERTIES("reserved words as properties", ES5),
        SETTER("setters", ES5),
        STRING_CONTINUATION("string continuation", ES5),
        TRAILING_COMMA("trailing comma", ES5),
        ARROW_FUNCTIONS("arrow function", ES6_IMPL),
        BINARY_LITERALS("binary literal", ES6_IMPL),
        OCTAL_LITERALS("octal literal", ES6_IMPL),
        CLASSES("class", ES6_IMPL),
        COMPUTED_PROPERTIES("computed property", ES6_IMPL),
        CONST_DECLARATIONS("const declaration", ES6_IMPL),
        EXTENDED_OBJECT_LITERALS("extended object literal", ES6_IMPL),
        FOR_OF("for-of loop", ES6_IMPL),
        GENERATORS("generator", ES6_IMPL),
        LET_DECLARATIONS("let declaration", ES6_IMPL),
        MEMBER_DECLARATIONS("member declaration", ES6_IMPL),
        REST_PARAMETERS("rest parameter", ES6_IMPL),
        SPREAD_EXPRESSIONS("spread expression", ES6_IMPL),
        SUPER("super", ES6_IMPL),
        TEMPLATE_LITERALS("template literal", ES6_IMPL),
        DEFAULT_PARAMETERS("default parameter", ES6),
        DESTRUCTURING("destructuring", ES6),
        REGEXP_FLAG_U("RegExp flag 'u'", ES6),
        REGEXP_FLAG_Y("RegExp flag 'y'", ES6),
        MODULES("modules", ES6_MODULES),
        AMBIENT_DECLARATION("ambient declaration", TYPESCRIPT),
        CALL_SIGNATURE("call signature", TYPESCRIPT),
        CONSTRUCTOR_SIGNATURE("constructor signature", TYPESCRIPT),
        ENUM("enum", TYPESCRIPT),
        GENERICS("generics", TYPESCRIPT),
        IMPLEMENTS("implements", TYPESCRIPT),
        INDEX_SIGNATURE("index signature", TYPESCRIPT),
        INTERFACE("interface", TYPESCRIPT),
        MEMBER_VARIABLE_IN_CLASS("member variable in class", TYPESCRIPT),
        NAMESPACE_DECLARATION("namespace declaration", TYPESCRIPT),
        OPTIONAL_PARAMETER("optional parameter", TYPESCRIPT),
        TYPE_ALIAS("type alias", TYPESCRIPT),
        TYPE_ANNOTATION("type annotation", TYPESCRIPT);

        private final String name;
        private final FeatureSet features;

        private Feature(String name, FeatureSet features) {
            this.name = name;
            this.features = features;
        }

        public FeatureSet features() {
            return this.features;
        }

        public String toString() {
            return this.name;
        }
    }
}

