/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XPathDecimalFormat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSDouble
extends NumericType {
    private static final String XS_DOUBLE = "xs:double";
    private Double _value;
    private XPathDecimalFormat format = new XPathDecimalFormat("0.################E0");

    public XSDouble(double x) {
        this._value = new Double(x);
    }

    public XSDouble() {
        this(0.0);
    }

    public XSDouble(String init) throws DynamicError {
        try {
            this._value = init.equals("-INF") ? new Double(Double.NEGATIVE_INFINITY) : (init.equals("INF") ? new Double(Double.POSITIVE_INFINITY) : new Double(init));
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public static XSDouble parse_double(String i) {
        try {
            Double d = null;
            d = i.equals("INF") ? new Double(Double.POSITIVE_INFINITY) : (i.equals("-INF") ? new Double(Double.NEGATIVE_INFINITY) : new Double(i));
            return new XSDouble(d);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence constructor(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSDouble d = this.castDouble(aat);
        if (d == null) {
            throw DynamicError.cant_cast(null);
        }
        return d;
    }

    private boolean isCastable(Item aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType) {
            return true;
        }
        return aat instanceof XSBoolean || aat instanceof NumericType;
    }

    private XSDouble castDouble(Item aat) {
        if (aat instanceof XSBoolean) {
            if (aat.getStringValue().equals("true")) {
                return new XSDouble(1.0);
            }
            return new XSDouble(0.0);
        }
        return XSDouble.parse_double(aat.getStringValue());
    }

    @Override
    public String string_type() {
        return XS_DOUBLE;
    }

    @Override
    public String type_name() {
        return "double";
    }

    @Override
    public String getStringValue() {
        if (this.zero()) {
            return "0";
        }
        if (this.negativeZero()) {
            return "-0";
        }
        if (this.nan()) {
            return "NaN";
        }
        return this.format.xpathFormat(this._value);
    }

    public boolean nan() {
        return Double.isNaN(this._value);
    }

    public boolean infinite() {
        return Double.isInfinite(this._value);
    }

    @Override
    public boolean zero() {
        return Double.compare(this._value, 0.0) == 0;
    }

    public boolean negativeZero() {
        return Double.compare(this._value, -0.0) == 0;
    }

    public double double_value() {
        return this._value;
    }

    @Override
    public boolean eq(AnyType aa, DynamicContext dynamicContext) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new(aa);
        org.eclipse.wst.xml.xpath2.api.ResultSequence crs = this.constructor(rs);
        if (crs.empty()) {
            throw DynamicError.throw_type_error();
        }
        Item cat = crs.first();
        XSDouble d = (XSDouble)cat;
        if (d.nan() && this.nan()) {
            return false;
        }
        Double thatvalue = new Double(d.double_value());
        Double thisvalue = new Double(this.double_value());
        return thisvalue.equals(thatvalue);
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        return this.double_value() > val.double_value();
    }

    protected Item convertArg(AnyType arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence rs = ResultSequenceFactory.create_new(arg);
        rs = this.constructor(rs);
        Item carg = rs.first();
        return carg;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        return this.double_value() < val.double_value();
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence plus(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        Item at = this.get_single_arg(carg);
        if (!(at instanceof XSDouble)) {
            DynamicError.throw_type_error();
        }
        XSDouble val = (XSDouble)at;
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() + val.double_value()));
    }

    private org.eclipse.wst.xml.xpath2.api.ResultSequence convertResultSequence(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = arg;
        Iterator<Item> it = carg.iterator();
        while (it.hasNext()) {
            AnyType type = (AnyType)it.next();
            if (!type.string_type().equals("xs:untypedAtomic") && !type.string_type().equals("xs:string")) continue;
            throw DynamicError.throw_type_error();
        }
        carg = this.constructor(carg);
        return carg;
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence minus(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() - val.double_value()));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence times(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() * val.double_value()));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence div(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() / val.double_value()));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence idiv(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        if (this.nan() || val.nan()) {
            throw DynamicError.numeric_overflow("Dividend or divisor is NaN");
        }
        if (this.infinite()) {
            throw DynamicError.numeric_overflow("Dividend is infinite");
        }
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = new BigDecimal(this.double_value() / val.double_value());
        return ResultSequenceFactory.create_new(new XSInteger(result.toBigInteger()));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence mod(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDouble val = (XSDouble)XSDouble.get_single_type(carg, XSDouble.class);
        return ResultSequenceFactory.create_new(new XSDouble(this.double_value() % val.double_value()));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSDouble(-1.0 * this.double_value()));
    }

    @Override
    public NumericType abs() {
        return new XSDouble(Math.abs(this.double_value()));
    }

    @Override
    public NumericType ceiling() {
        return new XSDouble(Math.ceil(this.double_value()));
    }

    @Override
    public NumericType floor() {
        return new XSDouble(Math.floor(this.double_value()));
    }

    @Override
    public NumericType round() {
        BigDecimal value = new BigDecimal(this._value);
        BigDecimal round = value.setScale(0, 4);
        return new XSDouble(round.doubleValue());
    }

    @Override
    public NumericType round_half_to_even() {
        return this.round_half_to_even(0);
    }

    @Override
    public NumericType round_half_to_even(int precision) {
        BigDecimal value = new BigDecimal(this._value);
        BigDecimal round = value.setScale(precision, 6);
        return new XSDouble(round.doubleValue());
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_DOUBLE;
    }

    @Override
    public Object getNativeValue() {
        return this.double_value();
    }
}

