/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.zest.fx.models.HidingModel;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class ShowHiddenNeighborsOperation
extends AbstractOperation
implements ITransactionalOperation {
    private NodePart nodePart;
    private HidingModel hidingModel;
    private List<NodePart> shownNeighbors = new ArrayList<NodePart>();

    public ShowHiddenNeighborsOperation(IViewer viewer, NodePart nodePart) {
        super("ShowHiddenNeighbors");
        this.nodePart = nodePart;
        this.hidingModel = (HidingModel)viewer.getAdapter(HidingModel.class);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.shownNeighbors.clear();
        Set<NodePart> hiddenNeighbors = this.hidingModel.getHiddenNeighborParts(this.nodePart);
        if (hiddenNeighbors != null && !hiddenNeighbors.isEmpty()) {
            for (NodePart neighborPart : hiddenNeighbors) {
                neighborPart.activate();
                this.hidingModel.show(neighborPart);
                this.shownNeighbors.add(neighborPart);
            }
        }
        return Status.OK_STATUS;
    }

    public boolean isContentRelevant() {
        return false;
    }

    public boolean isNoOp() {
        Set<NodePart> hiddenNeighbors = this.hidingModel.getHiddenNeighborParts(this.nodePart);
        return hiddenNeighbors != null && !hiddenNeighbors.isEmpty();
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (NodePart neighborPart : this.shownNeighbors) {
            this.hidingModel.hide(neighborPart);
            neighborPart.deactivate();
        }
        return Status.OK_STATUS;
    }
}

