/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.annotations;

import java.util.Objects;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.ee8.servlet.ServletContainerInitializerHolder;

public class ContainerInitializerAnnotationHandler
extends AnnotationParser.AbstractHandler {
    final ServletContainerInitializerHolder _holder;
    final Class<?> _annotation;

    public ContainerInitializerAnnotationHandler(ServletContainerInitializerHolder holder, Class<?> annotation) {
        this._holder = Objects.requireNonNull(holder);
        this._annotation = Objects.requireNonNull(annotation);
    }

    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (!this._annotation.getName().equals(annotationName)) {
            return;
        }
        this._holder.addStartupClasses(new String[]{info.getClassName()});
    }

    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (!this._annotation.getName().equals(annotationName)) {
            return;
        }
        this._holder.addStartupClasses(new String[]{info.getClassInfo().getClassName()});
    }

    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (!this._annotation.getName().equals(annotationName)) {
            return;
        }
        this._holder.addStartupClasses(new String[]{info.getClassInfo().getClassName()});
    }
}

