/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.TypeUtil;

public class OrderedSetTypeOperations
extends AbstractContextualOperations {
    static final String REVERSE_NAME = "reverse";
    static final CallHandler APPEND = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                MutableList result = CollectionUtil.append((Collection)((Collection)source), (Object)args[0]);
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler PREPEND = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                MutableList result = CollectionUtil.prepend((Collection)((Collection)source), (Object)args[0]);
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler INSERT_AT = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 1 && args[0] instanceof Integer) {
                if (args[1] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                MutableList result = CollectionUtil.insertAt((Collection)((Collection)source), (int)((Integer)args[0]), (Object)args[1]);
                if (source instanceof MutableList && !(result instanceof MutableList)) {
                    result = Utils.createList(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler INDEX_OF = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection && args.length > 0) {
                if (args[0] == CallHandlerAdapter.getInvalidResult(evalEnv)) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                Integer index = CollectionUtil.indexOf((Collection)((Collection)source), (Object)args[0]);
                if (index == null) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                return index;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler REVERSE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof Collection) {
                ArrayList result = new ArrayList((Collection)source);
                Collections.reverse(result);
                if (source instanceof MutableList) {
                    return EvaluationUtil.asList(result);
                }
                if (source instanceof LinkedHashSet) {
                    return CollectionUtil.asOrderedSet(result);
                }
                return CollectionUtil.asSequence(result);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };

    private OrderedSetTypeOperations(AbstractQVTStdlib library, EClassifier contextType) {
        super(library, contextType);
    }

    public static AbstractContextualOperations[] getAllOperations(AbstractQVTStdlib library) {
        QVTOEnvironment environment = library.getEnvironment();
        return new AbstractContextualOperations[]{new OrderedSetTypeOperations(library, (EClassifier)environment.getOCLStandardLibrary().getOrderedSet())};
    }

    @Override
    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary oclStdlib = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        EClassifier orderedSetOfCommonT = (EClassifier)TypeUtil.resolveOrderedSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getCommonT());
        return new AbstractContextualOperations.OperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(APPEND, "append", new String[]{"object"}, orderedSetOfCommonT, (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(PREPEND, "prepend", new String[]{"object"}, orderedSetOfCommonT, (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INSERT_AT, "insertAt", new String[]{"index", "object"}, orderedSetOfCommonT, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(INDEX_OF, "indexOf", new String[]{"object"}, (EClassifier)oclStdlib.getInteger(), (EClassifier)oclStdlib.getT2()), (AbstractContextualOperations)this.new AbstractContextualOperations.OperationProvider(REVERSE, REVERSE_NAME, (EClassifier)oclStdlib.getOrderedSet(), new EClassifier[0])};
    }
}

