/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.refactoring.core.changes.Messages;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameBuildAndIcludePathChange
extends Change {
    private IPath fDest;
    private IPath fSource;
    private String fName;
    private String fNewName;
    private List<IBuildpathEntry> newBuildEntries;
    private List<IBuildpathEntry> newIncludePathEntries;
    private List<IBuildpathEntry> oldBuildEntries;
    private List<IBuildpathEntry> oldIncludeEntries;

    public RenameBuildAndIcludePathChange(IPath source, IPath dest, String resName, String newName, List<IBuildpathEntry> oldBiuldEntries, List<IBuildpathEntry> newBiuldEntries, List<IBuildpathEntry> oldIncludePath, List<IBuildpathEntry> newIncludePathEntries) {
        this.fSource = source;
        this.fDest = dest;
        this.fName = resName;
        this.fNewName = newName;
        this.oldBuildEntries = oldBiuldEntries;
        this.newBuildEntries = newBiuldEntries;
        this.oldIncludeEntries = oldIncludePath;
        this.newIncludePathEntries = newIncludePathEntries;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return NLS.bind((String)Messages.RenameBuildAndIcludePathChange_0, (Object)this.fName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.performChanges(pm);
        return new RenameBuildAndIcludePathChange(this.fDest, this.fSource, this.fNewName, this.fName, this.newBuildEntries, this.oldBuildEntries, this.newIncludePathEntries, this.oldIncludeEntries);
    }

    protected void performChanges(IProgressMonitor pm) throws CoreException {
        IResource newResource = RefactoringUtility.getResource(this.fDest.append(this.fNewName));
        IProject newProject = newResource.getProject();
        IScriptProject newScriptProject = DLTKCore.create((IProject)newProject);
        if (this.newBuildEntries.size() > 0) {
            newScriptProject.setRawBuildpath(null, pm);
            newScriptProject.setRawBuildpath(this.newBuildEntries.toArray(new IBuildpathEntry[this.newBuildEntries.size()]), null);
        }
        if (this.newIncludePathEntries.size() > 0) {
            IncludePathManager.getInstance().addEntriesToIncludePath(newProject, this.newIncludePathEntries);
        }
        IncludePathManager.getInstance().refresh(newProject);
    }
}

