/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.widgets.TableWidget;
import org.eclipse.tm4e.ui.internal.widgets.TableWithControlsWidget;
import org.eclipse.tm4e.ui.internal.wizards.CreateThemeAssociationWizard;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;

public final class ThemeAssociationsWidget
extends TableWithControlsWidget<IThemeAssociation> {
    private final IThemeManager.EditSession themeManager;

    public ThemeAssociationsWidget(IThemeManager.EditSession themeManager, Composite parent) {
        super(parent, TMUIMessages.ThemeAssociationsWidget_description, false);
        this.themeManager = themeManager;
    }

    @Override
    protected TableWidget<IThemeAssociation> createTable(Composite parent) {
        return new TableWidget<IThemeAssociation>(parent, false){
            {
                this.getTable().setHeaderVisible(false);
            }

            @Override
            protected void createColumns() {
                this.createColumn("", 100, 0, new int[0]);
            }

            protected @Nullable String getColumnText(IThemeAssociation association, int columnIndex) {
                return switch (columnIndex) {
                    case 0 -> {
                        String themeId = association.getThemeId();
                        ITheme theme = TMUIPlugin.getThemeManager().getThemeById(themeId);
                        String themeName = theme != null ? theme.getName() : themeId;
                        boolean isDefaultThemeAssociation = themeId.equals(ThemeAssociationsWidget.this.themeManager.getDefaultTheme(association.isWhenDark()).getId());
                        yield NLS.bind((String)(association.isWhenDark() ? TMUIMessages.ThemeAssociationLabelProvider_dark : TMUIMessages.ThemeAssociationLabelProvider_light), (Object)(isDefaultThemeAssociation ? "default " : ""), (Object)themeName);
                    }
                    default -> null;
                };
            }

            @Override
            protected Object[] getElements(@Nullable Object input) {
                if (input instanceof IGrammarDefinition) {
                    IGrammarDefinition grammarDef = (IGrammarDefinition)input;
                    return ThemeAssociationsWidget.this.themeManager.getThemeAssociationsForScope(grammarDef.getScope().getName());
                }
                return super.getElements(input);
            }
        };
    }

    @Override
    protected void createButtons() {
        Button editButton = this.createButton(TMUIMessages.Button_edit, () -> {
            CreateThemeAssociationWizard wizard = new CreateThemeAssociationWizard(this.themeManager, false);
            wizard.setInitialDefinition(this.getGrammarDefinition());
            wizard.setInitialAssociation((IThemeAssociation)this.getTable().getFirstSelectedElement());
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                this.getTable().refresh();
                this.getTable().setSelection((IThemeAssociation)NullSafetyHelper.castNonNull((Object)wizard.getCreatedThemeAssociation()));
            }
        });
        Button removeButton = this.createButton(TMUIMessages.Button_remove, () -> {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)TMUIMessages.ThemeAssociationsWidget_remove_dialog_title, (String)TMUIMessages.ThemeAssociationsWidget_remove_dialog_message)) {
                this.themeManager.unregisterThemeAssociation((IThemeAssociation)NullSafetyHelper.castNonNull((Object)((IThemeAssociation)this.getTable().getFirstSelectedElement())));
                this.getTable().refresh();
            }
        });
        this.getTable().onSelectionChanged(associations -> {
            if (associations.isEmpty()) {
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
            } else {
                editButton.setEnabled(true);
                IThemeAssociation association = (IThemeAssociation)associations.get(0);
                boolean isDefaultThemeAssociation = association.getThemeId().equals(this.themeManager.getDefaultTheme(association.isWhenDark()).getId());
                removeButton.setEnabled(!isDefaultThemeAssociation);
            }
        });
    }

    public @Nullable IGrammarDefinition getGrammarDefinition() {
        IGrammarDefinition def;
        Object object = this.getTable().getInput();
        return object instanceof IGrammarDefinition ? (def = (IGrammarDefinition)object) : null;
    }

    public void setGrammarDefinition(IGrammarDefinition definition) {
        this.getTable().setInput(definition);
    }
}

