/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.LinkedHashMap;
import java.util.Map;

final class CharacterStringPool {
    private static LinkedHashMap fPool = new LimitedHashMap();

    private CharacterStringPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getCharString(String string) {
        CharArray array = new CharArray();
        array.fArray = string.toCharArray();
        CharArray obj = null;
        LinkedHashMap linkedHashMap = fPool;
        synchronized (linkedHashMap) {
            obj = (CharArray)fPool.get(array);
            if (obj == null) {
                obj = array;
                fPool.put(obj, obj);
            }
        }
        return obj.fArray;
    }

    private static class CharArray {
        char[] fArray;

        private CharArray() {
        }

        public int hashCode() {
            int hash;
            int length = this.fArray.length;
            int n = hash = length == 0 ? 31 : this.fArray[0];
            if (length < 8) {
                int i = length;
                while (--i > 0) {
                    hash = hash * 31 + this.fArray[i];
                }
            } else {
                int i = length - 1;
                int last = i > 16 ? i - 16 : 0;
                while (i > last) {
                    hash = hash * 31 + this.fArray[i];
                    i -= 2;
                }
            }
            return hash & Integer.MAX_VALUE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharArray)) {
                return false;
            }
            CharArray other = (CharArray)obj;
            if (this.fArray.length != other.fArray.length) {
                return false;
            }
            int i = 0;
            while (i < this.fArray.length) {
                if (this.fArray[i] != other.fArray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class LimitedHashMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private static final int MAX = 500;

        public LimitedHashMap() {
            super(50, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 500;
        }
    }
}

