/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletionStage;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AbstractUniversalComparableAssert;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.ClassBasedNavigableIterableAssert;
import org.assertj.core.api.ClassBasedNavigableListAssert;
import org.assertj.core.api.CollectionAssert;
import org.assertj.core.api.CompletableFutureAssert;
import org.assertj.core.api.DoublePredicateAssert;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.IntPredicateAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LongPredicateAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.PathAssert;
import org.assertj.core.api.PredicateAssert;
import org.assertj.core.api.SpliteratorAssert;
import org.assertj.core.api.UniversalComparableAssert;

@CheckReturnValue
public class AssertionsForInterfaceTypes
extends AssertionsForClassTypes {
    public static <T> T assertThat(AssertProvider<T> component) {
        return component.assertThat();
    }

    protected AssertionsForInterfaceTypes() {
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return CharSequenceAssert.assertThatCharSequence(actual);
    }

    public static <ELEMENT> IterableAssert<ELEMENT> assertThat(Iterable<? extends ELEMENT> actual) {
        return IterableAssert.assertThatIterable(actual);
    }

    public static <ELEMENT> IterableAssert<ELEMENT> assertThatIterable(Iterable<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static <ELEMENT> IteratorAssert<ELEMENT> assertThat(Iterator<? extends ELEMENT> actual) {
        return IteratorAssert.assertThatIterator(actual);
    }

    public static <ELEMENT> IteratorAssert<ELEMENT> assertThatIterator(Iterator<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static <E> AbstractCollectionAssert<?, Collection<? extends E>, E, ObjectAssert<E>> assertThat(Collection<? extends E> actual) {
        return CollectionAssert.assertThatCollection(actual);
    }

    public static <E> AbstractCollectionAssert<?, Collection<? extends E>, E, ObjectAssert<E>> assertThatCollection(Collection<? extends E> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static <ELEMENT> ListAssert<ELEMENT> assertThat(List<? extends ELEMENT> actual) {
        return ListAssert.assertThatList(actual);
    }

    public static <ELEMENT> ListAssert<ELEMENT> assertThatList(List<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static <ELEMENT> ListAssert<ELEMENT> assertThat(Stream<? extends ELEMENT> actual) {
        return ListAssert.assertThatStream(actual);
    }

    public static <ELEMENT> ListAssert<ELEMENT> assertThatStream(Stream<? extends ELEMENT> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static ListAssert<Double> assertThat(DoubleStream actual) {
        return ListAssert.assertThatDoubleStream(actual);
    }

    public static ListAssert<Long> assertThat(LongStream actual) {
        return ListAssert.assertThatLongStream(actual);
    }

    public static ListAssert<Integer> assertThat(IntStream actual) {
        return ListAssert.assertThatIntStream(actual);
    }

    @Deprecated
    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(Iterable<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return FactoryBasedNavigableIterableAssert.assertThat(actual, assertFactory);
    }

    @Deprecated
    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        return ClassBasedNavigableIterableAssert.assertThat(actual, assertClass);
    }

    @Deprecated
    public static <ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return FactoryBasedNavigableListAssert.assertThat(actual, assertFactory);
    }

    @Deprecated
    public static <ELEMENT, ACTUAL extends List<? extends ELEMENT>, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, Class<ELEMENT_ASSERT> assertClass) {
        return ClassBasedNavigableListAssert.assertThat(actual, assertClass);
    }

    public static AbstractPathAssert<?> assertThat(Path actual) {
        return PathAssert.assertThatPath(actual);
    }

    public static AbstractPathAssert<?> assertThatPath(Path actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return MapAssert.assertThatMap(actual);
    }

    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return new GenericComparableAssert<T>(actual);
    }

    public static <T> AbstractUniversalComparableAssert<?, T> assertThatComparable(Comparable<T> actual) {
        return new UniversalComparableAssert<T>(actual);
    }

    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }

    public static <T> PredicateAssert<T> assertThat(Predicate<T> actual) {
        return PredicateAssert.assertThatPredicate(actual);
    }

    public static <T> PredicateAssert<T> assertThatPredicate(Predicate<T> actual) {
        return AssertionsForInterfaceTypes.assertThat(actual);
    }

    public static IntPredicateAssert assertThat(IntPredicate actual) {
        return IntPredicateAssert.assertThatIntPredicate(actual);
    }

    public static LongPredicateAssert assertThat(LongPredicate actual) {
        return LongPredicateAssert.assertThatLongPredicate(actual);
    }

    public static DoublePredicateAssert assertThat(DoublePredicate actual) {
        return DoublePredicateAssert.assertThatDoublePredicate(actual);
    }

    public static <RESULT> CompletableFutureAssert<RESULT> assertThat(CompletionStage<RESULT> actual) {
        return CompletableFutureAssert.assertThatCompletionStage(actual);
    }

    public static <ELEMENT> SpliteratorAssert<ELEMENT> assertThat(Spliterator<ELEMENT> actual) {
        return SpliteratorAssert.assertThatSpliterator(actual);
    }
}

