/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.dialogs;

import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ProfileSelectionDialogPage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;

public class ProfileSelectionComposite {
    public static String JDBC_CATEGORY = "org.eclipse.datatools.connectivity.db.category";
    protected String _profile = null;
    protected String _category = null;
    protected ProfileSelectionDialogPage page = null;
    protected ViewerFilter _filter;
    protected HashMap _connectListeners = new HashMap();
    protected boolean _listenersInited = false;
    protected ListenerList changeListeners = new ListenerList();

    public ProfileSelectionComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public ProfileSelectionComposite(Composite parent, int style, String category) {
        this(parent, style, category, true, true, true, false, true);
    }

    public ProfileSelectionComposite(Composite parent, int style, String category, boolean limitToProfiles) {
        this(parent, style, category, limitToProfiles, true, true, false);
    }

    public ProfileSelectionComposite(Composite parent, int style, String category, boolean limitToProfiles, boolean canNew, boolean canConnect, boolean canSelect) {
        this(parent, style, category, limitToProfiles, canNew, canConnect, canSelect, true);
    }

    public ProfileSelectionComposite(Composite parent, int style, String category, boolean limitToProfiles, boolean canNew, boolean canConnect, boolean canSelect, boolean createNow) {
        this.setCategory(category);
        this.getPage().setLimitToProfiles(limitToProfiles);
        this.getPage().setShowConnect(canConnect);
        this.getPage().setShowNew(canNew);
        this.getPage().setShowSelectButtons(canSelect);
        if (createNow) {
            this.getPage().createControl(parent, false, false);
            IConnectionProfile profile = null;
            if (this._profile != null) {
                profile = ProfileManager.getInstance().getProfileByName(this._profile);
            }
            this.getPage().init(profile, null, this._filter, this.getCategoryObject());
        }
    }

    private void initListeners() {
        CommonViewer viewer = (CommonViewer)this.getPage().getNavigatorViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof IConnectionProfile) {
                    IConnectionProfile profile = (IConnectionProfile)selection.getFirstElement();
                    if (ProfileSelectionComposite.this._connectListeners.get(profile) == null) {
                        IPropertySetListener listener = new IPropertySetListener(){

                            public void propertySetChanged(IPropertySetChangeEvent event) {
                                if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connectionState") != null) {
                                    ProfileSelectionComposite.this.initListboxContent();
                                }
                            }
                        };
                        profile.addPropertySetListener(listener);
                        ProfileSelectionComposite.this._connectListeners.put(profile, listener);
                    }
                    if (ProfileSelectionComposite.this._listenersInited && ProfileSelectionComposite.this._profile != profile.getName()) {
                        ProfileSelectionComposite.this._profile = profile.getName();
                        ProfileSelectionComposite.this.fireChangedEvent(ProfileSelectionComposite.this);
                    }
                }
                ProfileSelectionComposite.this.validate();
            }
        });
        this._listenersInited = true;
    }

    public ProfileSelectionDialogPage createProfileDatabaseSelectionDialogPage() {
        return new ProfileSelectionDialogPage("Property Page Title");
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public String getCategory() {
        return this._category;
    }

    protected ICategory getCategoryObject() {
        if (this._category != null) {
            return ProfileManager.getInstance().getCategory(this._category);
        }
        return null;
    }

    public ProfileSelectionDialogPage getPage() {
        if (this.page == null) {
            this.page = this.createProfileDatabaseSelectionDialogPage();
        }
        return this.page;
    }

    public void fillInDefaultValues() {
        this.initListboxContent();
        if (!this._listenersInited) {
            this.initListeners();
        }
        this.validate();
    }

    protected void initListboxContent() {
        final TreeViewer viewer = this.getPage().getNavigatorViewer();
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                viewer.refresh();
                if (ProfileSelectionComposite.this.getPage().getLimitToProfiles()) {
                    viewer.expandAll();
                }
            }
        });
        Display.getCurrent().readAndDispatch();
        if (this._profile != null) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(ProfileSelectionComposite.this._profile);
                    ProfileSelectionComposite.this.getPage().select(profile);
                }
            });
        }
    }

    public String getCPName() {
        return this._profile;
    }

    public void setCPName(String input) {
        this._profile = input;
    }

    public ViewerFilter getCustomFilter() {
        return this._filter;
    }

    public void setCustomFilter(ViewerFilter input) {
        this._filter = input;
    }

    protected boolean validate() {
        boolean hasProfile = false;
        if (this._profile != null && this._profile.trim().length() > 0) {
            hasProfile = true;
        }
        this.getPage().validate();
        return hasProfile;
    }

    public void dispose() {
        if (!this._connectListeners.isEmpty()) {
            for (IConnectionProfile profile : this._connectListeners.keySet()) {
                profile.removePropertySetListener((IPropertySetListener)this._connectListeners.get(profile));
            }
        }
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }
}

