/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.printer;

import java.util.List;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.emf.common.util.EList;

public class SimpleCodePrinter {
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";

    public static String getArgumentString(TclArgument arg, int pos) {
        return SimpleCodePrinter.getArgumentString(arg, pos, true);
    }

    public static String getArgumentString(TclArgument arg, int pos, boolean addSpaces) {
        StringBuilder buff = new StringBuilder();
        int start = arg.getStart();
        if (addSpaces && start > pos) {
            int i = 0;
            while (i < start - pos) {
                buff.append(SPACE);
                ++i;
            }
        }
        if (arg instanceof StringArgument) {
            StringArgument argument = (StringArgument)arg;
            String value = argument.getValue();
            buff.append(value);
            return buff.toString();
        }
        if (arg instanceof ComplexString) {
            ComplexString carg = (ComplexString)arg;
            EList<TclArgument> eList = carg.getArguments();
            if (carg.getKind() == 1) {
                buff.append(LEFT_BRACE);
            } else if (carg.getKind() == 2) {
                buff.append(QUOTE);
            }
            for (TclArgument tclArgument : eList) {
                buff.append(SimpleCodePrinter.getArgumentString(tclArgument, pos + buff.length(), addSpaces));
            }
            int end = arg.getEnd() - 1;
            if (carg.getKind() == 0) {
                ++end;
            }
            int npos = pos + buff.length();
            if (addSpaces && end > npos) {
                int i = 0;
                while (i < end - npos) {
                    buff.append(SPACE);
                    ++i;
                }
            }
            if (carg.getKind() == 1) {
                buff.append(RIGHT_BRACE);
            } else if (carg.getKind() == 2) {
                buff.append(QUOTE);
            }
            return buff.toString();
        }
        if (arg instanceof Script) {
            Script st = (Script)arg;
            buff.append(LEFT_BRACE);
            boolean added = false;
            for (TclCommand command : st.getCommands()) {
                if (!added) {
                    added = true;
                } else {
                    buff.append("\n    ");
                }
                buff.append(SimpleCodePrinter.getCommandString(command, pos + buff.length(), addSpaces));
            }
            int end = arg.getEnd();
            int npos = pos + buff.length();
            if (addSpaces && end - 1 > npos) {
                int i = 0;
                while (i < end - 1 - npos) {
                    buff.append(SPACE);
                    ++i;
                }
            }
            buff.append(RIGHT_BRACE);
            return buff.toString();
        }
        if (arg instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)arg;
            buff.append("$").append(variableReference.getName());
            if (variableReference.getIndex() != null) {
                buff.append("(").append(SimpleCodePrinter.getArgumentString(variableReference.getIndex(), pos + buff.length(), addSpaces)).append(")");
            }
            return buff.toString();
        }
        if (arg instanceof Substitution) {
            Substitution st = (Substitution)arg;
            buff.append(LEFT_BRACKET);
            boolean added = false;
            for (TclCommand command : st.getCommands()) {
                if (!added) {
                    added = true;
                } else {
                    buff.append("\n    ");
                }
                buff.append(SimpleCodePrinter.getCommandString(command, pos + buff.length()));
            }
            int end = arg.getEnd() - 1;
            int npos = pos + buff.length();
            if (addSpaces && end > npos) {
                int i = 0;
                while (i < end - npos) {
                    buff.append(SPACE);
                    ++i;
                }
            }
            buff.append(RIGHT_BRACKET);
            return buff.toString();
        }
        if (arg instanceof TclArgumentList) {
            TclArgumentList st = (TclArgumentList)arg;
            EList<TclArgument> eList = st.getArguments();
            if (st.getKind() == 1) {
                buff.append(LEFT_BRACE);
            } else if (st.getKind() == 2) {
                buff.append(QUOTE);
            }
            for (TclArgument tclArgument : eList) {
                buff.append(SimpleCodePrinter.getArgumentString(tclArgument, pos + buff.length(), addSpaces));
            }
            int end = arg.getEnd() - 1;
            if (st.getKind() == 0) {
                ++end;
            }
            int npos = pos + buff.length();
            if (addSpaces && end > npos) {
                int i = 0;
                while (i < end - npos) {
                    buff.append(SPACE);
                    ++i;
                }
            }
            if (st.getKind() == 1) {
                buff.append(RIGHT_BRACE);
            } else if (st.getKind() == 2) {
                buff.append(QUOTE);
            }
            return buff.toString();
        }
        return "";
    }

    public static String getCommandString(TclCommand command, int pos) {
        return SimpleCodePrinter.getCommandString(command, pos, true);
    }

    public static String getCommandString(TclCommand command, int pos, boolean addSpaces) {
        StringBuilder buff = new StringBuilder();
        int start = command.getStart();
        if (addSpaces && start > pos) {
            int i = 0;
            while (i < start - pos) {
                buff.append(SPACE);
                ++i;
            }
        }
        buff.append(SimpleCodePrinter.getArgumentString(command.getName(), start, addSpaces));
        for (TclArgument tclArgument : command.getArguments()) {
            buff.append(SimpleCodePrinter.getArgumentString(tclArgument, pos + buff.length(), addSpaces));
        }
        return buff.toString();
    }

    public static String getCommandsString(List<TclCommand> commands) {
        return SimpleCodePrinter.getCommandsString(commands, true);
    }

    public static String getCommandsString(List<TclCommand> commands, boolean addSpaces) {
        StringBuilder buff = new StringBuilder();
        boolean first = false;
        int pos = 0;
        for (TclCommand command : commands) {
            if (!first) {
                first = true;
            } else {
                buff.append("\n");
            }
            String text = SimpleCodePrinter.getCommandString(command, pos, addSpaces);
            buff.append(text);
            pos += text.length();
        }
        return buff.toString();
    }
}

