/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryFactory;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.RepositoryActivityLog;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ParameterAware;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.XMLUtil;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.factory.PropertiesFactory;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.operations.OperationAuthorizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RepositoryConfigurator
implements IManagedContainerProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, RepositoryConfigurator.class);
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_STORE = "store";
    private static final String ELEM_USER_MANAGER = "userManager";
    private static final String ELEM_AUTHENTICATOR = "authenticator";
    private static final String ELEM_OPERATION_AUTHORIZER = "operationAuthorizer";
    private static final String ELEM_ACTIVITY_LOG = "activityLog";
    private static final String ELEM_INITIAL_PACKAGE = "initialPackage";
    private static final String[] BUILTIN_ELEMENTS = new String[]{"property", "store", "userManager", "authenticator", "operationAuthorizer", "activityLog", "initialPackage"};
    private static final Set<String> BUILTIN_ELEMENTS_SET = new HashSet<String>(Arrays.asList(BUILTIN_ELEMENTS));
    private final IManagedContainer container;
    private final Map<String, IRepositoryFactory> repositoryFactories = new HashMap<String, IRepositoryFactory>();
    private final Map<String, IStoreFactory> storeFactories = new HashMap<String, IStoreFactory>();
    private final Map<String, String> parameters = new HashMap<String, String>();

    public RepositoryConfigurator() {
        this(null);
    }

    public RepositoryConfigurator(IManagedContainer container) {
        this.container = container;
        this.parameters.put("@user", OMPlatform.INSTANCE.getUserFolder().getAbsolutePath());
        this.parameters.put("@state", OMPlatform.INSTANCE.getStateFolder().getAbsolutePath());
        this.parameters.put("@config", OMPlatform.INSTANCE.getConfigFolder().getAbsolutePath());
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public Map<String, IRepositoryFactory> getRepositoryFactories() {
        return this.repositoryFactories;
    }

    public Map<String, IStoreFactory> getStoreFactories() {
        return this.storeFactories;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String setParameter(String key, String value) {
        if (value == null) {
            return this.parameters.remove(key);
        }
        return this.parameters.put(key, value);
    }

    public IRepository[] configure(File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from " + configFile.getAbsolutePath());
        }
        return this.configure(this.getDocument(configFile));
    }

    public IRepository[] configure(Reader configReader) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from dynamic configuration");
        }
        return this.configure(this.getDocument(configReader));
    }

    protected IRepository[] configure(Document document) throws ParserConfigurationException, SAXException, IOException, CoreException {
        ArrayList repositories = new ArrayList();
        try {
            RepositoryConfigurator.forEachChildElement(document.getDocumentElement(), "repository", repositoryConfig -> {
                IRepository repository = this.getRepository(repositoryConfig);
                repositories.add(repository);
                if (this.container != null) {
                    CDOServerUtil.addRepository(this.container, repository);
                    OM.LOG.info("CDO repository " + repository.getName() + " started");
                } else {
                    OM.LOG.info("CDO repository " + repository.getName() + " added");
                }
            });
        }
        catch (IOException | Error | RuntimeException | ParserConfigurationException | CoreException | SAXException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        return repositories.toArray(new IRepository[repositories.size()]);
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected Document getDocument(Reader configReader) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(configReader));
    }

    protected IRepositoryFactory getRepositoryFactory(String type) throws CoreException {
        IRepositoryFactory factory = this.repositoryFactories.get(type);
        if (factory == null) {
            factory = (IRepositoryFactory)RepositoryConfigurator.createExecutableExtension("repositoryFactories", "repositoryFactory", "repositoryType", type);
        }
        if (factory == null) {
            throw new IllegalStateException("Repository factory not found: " + type);
        }
        return factory;
    }

    protected IRepository getRepository(Element repositoryConfig) throws CoreException {
        String repositoryName = this.getAttribute(repositoryConfig, "name");
        if (StringUtil.isEmpty((String)repositoryName)) {
            throw new IllegalArgumentException("Repository name is missing or empty");
        }
        OM.LOG.info("CDO repository " + repositoryName + " starting");
        String repositoryType = this.getAttribute(repositoryConfig, "type");
        if (StringUtil.isEmpty((String)repositoryType)) {
            repositoryType = "default";
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Configuring repository {0} (type={1})", new Object[]{repositoryName, repositoryType});
        }
        Map<String, String> properties = RepositoryConfigurator.getProperties(repositoryConfig, 1, this.parameters, this.container);
        Element storeConfig = this.getStoreConfig(repositoryConfig);
        IStore store = this.createStore(repositoryName, properties, storeConfig);
        InternalRepository repository = (InternalRepository)this.getRepository(repositoryType);
        repository.setName(repositoryName);
        repository.setStore((InternalStore)store);
        repository.setProperties(properties);
        this.setUserManager(repository, repositoryConfig);
        this.setAuthenticator(repository, repositoryConfig);
        this.addOperationAuthorizers(repository, repositoryConfig);
        this.setActivityLog(repository, repositoryConfig);
        EPackage[] initialPackages = this.getInitialPackages(repositoryConfig);
        if (initialPackages.length != 0) {
            repository.setInitialPackages(initialPackages);
        }
        NodeList children = repositoryConfig.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String message;
            Extension extension;
            Element childElement;
            String childName;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && !BUILTIN_ELEMENTS_SET.contains(childName = (childElement = (Element)child).getNodeName()) && (extension = (Extension)this.container.getElementOrNull("org.eclipse.emf.cdo.server.repositoryConfiguratorExtensions", childName)) != null && !StringUtil.isEmpty((String)(message = extension.configureRepository(repository, childElement, this.parameters, this.container)))) {
                OM.LOG.info("CDO repository " + repository.getName() + " " + message);
            }
            ++i;
        }
        return repository;
    }

    protected IRepository getRepository(String repositoryType) throws CoreException {
        IRepositoryFactory factory = this.getRepositoryFactory(repositoryType);
        return factory.createRepository();
    }

    protected Element getUserManagerConfig(Element repositoryConfig) {
        return this.getChildElement(repositoryConfig, ELEM_USER_MANAGER);
    }

    protected IUserManager getUserManager(Element userManagerConfig) throws CoreException {
        String type = this.getAttribute(userManagerConfig, "type");
        String description = this.getAttribute(userManagerConfig, "description");
        return this.getUserManager(type, description);
    }

    protected IUserManager getUserManager(String type, String description) throws CoreException {
        IUserManager userManager = (IUserManager)this.container.getElement("org.eclipse.net4j.userManagers", type, description);
        if (userManager == null) {
            throw new IllegalStateException("UserManager factory not found: " + type);
        }
        return userManager;
    }

    protected void setUserManager(InternalRepository repository, Element repositoryConfig) throws CoreException {
        IUserManager userManager;
        Element userManagerConfig = this.getUserManagerConfig(repositoryConfig);
        if (userManagerConfig != null && (userManager = this.getUserManager(userManagerConfig)) != null) {
            InternalSessionManager sessionManager = repository.getSessionManager();
            if (sessionManager == null) {
                sessionManager = new SessionManager();
                repository.setSessionManager(sessionManager);
            }
            sessionManager.setUserManager(userManager);
        }
    }

    protected Element getAuthenticatorConfig(Element repositoryConfig) {
        return this.getChildElement(repositoryConfig, ELEM_AUTHENTICATOR);
    }

    protected IAuthenticator getAuthenticator(Element authenticatorConfig) throws CoreException {
        String type = this.getAttribute(authenticatorConfig, "type");
        String description = this.getAttribute(authenticatorConfig, "description");
        return this.getAuthenticator(type, description);
    }

    protected IAuthenticator getAuthenticator(String type, String description) throws CoreException {
        IAuthenticator authenticator = (IAuthenticator)this.container.getElement("org.eclipse.net4j.authenticators", type, description);
        if (authenticator == null) {
            throw new IllegalStateException("Authenticator factory not found: " + type);
        }
        return authenticator;
    }

    protected void setAuthenticator(InternalRepository repository, Element repositoryConfig) throws CoreException {
        IAuthenticator authenticator;
        Element authenticatorConfig = this.getAuthenticatorConfig(repositoryConfig);
        if (authenticatorConfig != null && (authenticator = this.getAuthenticator(authenticatorConfig)) != null) {
            InternalSessionManager sessionManager = repository.getSessionManager();
            if (sessionManager == null) {
                sessionManager = new SessionManager();
                repository.setSessionManager(sessionManager);
            }
            sessionManager.setAuthenticator(authenticator);
        }
    }

    protected void addOperationAuthorizers(InternalRepository repository, Element repositoryConfig) throws CoreException {
        NodeList children = repositoryConfig.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equalsIgnoreCase(ELEM_OPERATION_AUTHORIZER)) {
                String type = this.getAttribute(childElement, "type");
                if (type == null) {
                    throw new IllegalStateException("type missing for operationAuthorizer element");
                }
                String description = this.getAttribute(childElement, "description");
                if (!StringUtil.isEmpty((String)description)) {
                    this.addOperationAuthorizer(repository, type, description);
                } else {
                    String operations = this.getAttribute(childElement, "operations");
                    if (StringUtil.isEmpty((String)operations)) {
                        operations = this.getAttribute(childElement, "operation");
                    }
                    String values = null;
                    if (!StringUtil.isEmpty((String)operations)) {
                        values = this.getAttribute(childElement, "values");
                        if (StringUtil.isEmpty((String)values)) {
                            values = this.getAttribute(childElement, "value");
                        }
                        String[] stringArray = operations.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String operation;
                            description = operation = stringArray[n2];
                            if (!StringUtil.isEmpty((String)values)) {
                                description = String.valueOf(description) + ':' + values;
                            }
                            this.addOperationAuthorizer(repository, type, description);
                            ++n2;
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void addOperationAuthorizer(InternalRepository repository, String type, String description) throws CoreException {
        OperationAuthorizer<ISession> authorizer = this.getOperationAuthorizer(type, description);
        OM.LOG.info("Adding operation authorizer " + type + ": " + description);
        repository.addOperationAuthorizer(authorizer);
    }

    protected OperationAuthorizer<ISession> getOperationAuthorizer(String type, String description) throws CoreException {
        OperationAuthorizer authorizer = (OperationAuthorizer)this.container.getElementOrNull("org.eclipse.net4j.util.security.operationAuthorizers", type, description);
        if (authorizer == null) {
            throw new IllegalStateException("Operation authorizer factory not found: " + type);
        }
        return authorizer;
    }

    protected void setActivityLog(InternalRepository repository, Element repositoryConfig) {
        Element activityLogElement = this.getChildElement(repositoryConfig, ELEM_ACTIVITY_LOG);
        if (activityLogElement != null) {
            RepositoryActivityLog activityLog = (RepositoryActivityLog)((Object)this.getContainerElement(activityLogElement, "rolling"));
            activityLog.setRepository(repository);
        }
    }

    protected EPackage[] getInitialPackages(Element repositoryConfig) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        NodeList children = repositoryConfig.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equalsIgnoreCase(ELEM_INITIAL_PACKAGE)) {
                String nsURI = this.getAttribute(childElement, "nsURI");
                if (nsURI == null) {
                    throw new IllegalStateException("nsURI missing for initialPackage element");
                }
                EPackage initialPackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                if (initialPackage == null) {
                    throw new IllegalStateException("Initial package not found in global package registry: " + nsURI);
                }
                OM.LOG.info("Adding initial packages: " + nsURI);
                result.add(initialPackage);
            }
            ++i;
        }
        return result.toArray(new EPackage[result.size()]);
    }

    protected Element getStoreConfig(Element repositoryConfig) {
        Element storeElement = this.getChildElement(repositoryConfig, ELEM_STORE);
        if (storeElement == null) {
            String repositoryName = this.getAttribute(repositoryConfig, "name");
            throw new IllegalStateException("A store must be configured for repository " + repositoryName);
        }
        return storeElement;
    }

    protected IStoreFactory getStoreFactory(String type) throws CoreException {
        IStoreFactory factory = this.storeFactories.get(type);
        if (factory == null) {
            factory = (IStoreFactory)RepositoryConfigurator.createExecutableExtension("storeFactories", "storeFactory", "storeType", type);
        }
        if (factory == null) {
            throw new IllegalStateException("Store factory not found: " + type);
        }
        return factory;
    }

    protected IStore createStore(String repositoryName, Map<String, String> repositoryProperties, Element storeConfig) throws CoreException {
        String type = this.getAttribute(storeConfig, "type");
        IStoreFactory storeFactory = this.getStoreFactory(type);
        if (storeFactory instanceof IManagedContainer.ContainerAware) {
            ((IManagedContainer.ContainerAware)storeFactory).setManagedContainer(this.container);
        }
        if (storeFactory instanceof ParameterAware) {
            ((ParameterAware)storeFactory).setParameters(this.parameters);
        }
        return storeFactory.createStore(repositoryName, repositoryProperties, storeConfig);
    }

    protected <T> T getContainerElement(Element element, String defaultType) {
        String description;
        String type = this.getAttribute(element, "type");
        if (StringUtil.isEmpty((String)type)) {
            type = defaultType;
        }
        if (StringUtil.isEmpty((String)(description = this.getAttribute(element, "description")))) {
            Map<String, String> properties = RepositoryConfigurator.getProperties(element, 1, this.parameters, this.container);
            description = PropertiesFactory.createDescription(properties);
        }
        Object containerElement = this.container.getElement("org.eclipse.emf.cdo.server.repositoryActivityLogs", type, description);
        return (T)containerElement;
    }

    protected Element getChildElement(Element element, String name) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equalsIgnoreCase(name)) {
                return childElement;
            }
            ++i;
        }
        return null;
    }

    protected String getAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        value = RepositoryConfigurator.expandValue(value, this.parameters, this.container);
        return value;
    }

    public static void forEachChildElement(Element element, String name, XMLUtil.ElementHandler handler) throws Exception {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equalsIgnoreCase(name)) {
                handler.handleElement(childElement);
            }
            ++i;
        }
    }

    public static String expandValue(String value, Map<String, String> parameters, IManagedContainer container) {
        value = StringUtil.replace((String)value, parameters);
        value = StringUtil.convert((String)value, (IManagedContainer)container);
        return value;
    }

    public static Map<String, String> getProperties(Element element, int levels) {
        return RepositoryConfigurator.getProperties(element, levels, null);
    }

    public static Map<String, String> getProperties(Element element, int levels, Map<String, String> parameters) {
        HashMap<String, String> properties = new HashMap<String, String>();
        RepositoryConfigurator.collectProperties(element, "", properties, levels, parameters, (IManagedContainer)IPluginContainer.INSTANCE);
        return properties;
    }

    public static Map<String, String> getProperties(Element element, int levels, Map<String, String> parameters, IManagedContainer container) {
        HashMap<String, String> properties = new HashMap<String, String>();
        RepositoryConfigurator.collectProperties(element, "", properties, levels, parameters, container);
        return properties;
    }

    private static void collectProperties(Element element, String prefix, Map<String, String> properties, int levels, Map<String, String> parameters, IManagedContainer container) {
        if (ELEM_PROPERTY.equals(element.getNodeName())) {
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            value = RepositoryConfigurator.expandValue(value, parameters, container);
            properties.put(String.valueOf(prefix) + name, value);
            prefix = String.valueOf(prefix) + name + ".";
        }
        if (levels > 0) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    RepositoryConfigurator.collectProperties((Element)childNode, prefix, properties, levels - 1, parameters, container);
                }
                ++i;
            }
        }
    }

    private static <T> T createExecutableExtension(String extPointName, String elementName, String attributeName, String type) throws CoreException {
        if (OMPlatform.INSTANCE.isExtensionRegistryAvailable()) {
            IConfigurationElement[] elements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", extPointName);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String storeType;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (ObjectUtil.equals((Object)element.getName(), (Object)elementName) && ObjectUtil.equals((Object)(storeType = element.getAttribute(attributeName)), (Object)type)) {
                    Object result = element.createExecutableExtension("class");
                    return (T)result;
                }
                ++n2;
            }
        }
        return null;
    }

    @Deprecated
    public static String substituteParameters(String str, Map<String, String> parameters) {
        return StringUtil.replace((String)str, parameters);
    }

    public static interface Extension {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryConfiguratorExtensions";

        public String configureRepository(InternalRepository var1, Element var2, Map<String, String> var3, IManagedContainer var4);
    }

    public static abstract class Factory
    extends org.eclipse.net4j.util.factory.Factory
    implements IManagedContainer.ContainerAware {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.repositoryConfigurators";
        private IManagedContainer container;

        public Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public void setManagedContainer(IManagedContainer container) {
            this.container = container;
        }

        public final RepositoryConfigurator create(String description) throws ProductCreationException {
            return this.create(this.container, description);
        }

        public abstract RepositoryConfigurator create(IManagedContainer var1, String var2) throws ProductCreationException;

        public static final class Default
        extends Factory {
            public static final String TYPE = "default";

            public Default() {
                super(TYPE);
            }

            @Override
            public RepositoryConfigurator create(IManagedContainer container, String description) throws ProductCreationException {
                return new RepositoryConfigurator(container);
            }
        }
    }

    public static abstract class TreeExtension
    implements Extension {
        @Override
        public String configureRepository(InternalRepository repository, Element extensionConfig, Map<String, String> parameters, IManagedContainer container) {
            Tree config = Tree.XMLConverter.convertElementToTree((Element)extensionConfig, parameters);
            return this.configureRepository(repository, config, parameters, container);
        }

        protected abstract String configureRepository(InternalRepository var1, Tree var2, Map<String, String> var3, IManagedContainer var4);
    }
}

