/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import java.util.List;
import java.util.Vector;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.w3c.dom.Node;

public class CutNodeCommand
extends DesignerCommand {
    private static final String COMMAND_LABEL = CommandResources.getString("CutNodeCommand.Label.CutNode");

    @Override
    protected void doExecute() {
        List parts = this.getViewer().getSelectedEditParts();
        Vector<Object> result = new Vector<Object>();
        if (parts.size() > 0) {
            int i = 0;
            int n = parts.size();
            while (i < n) {
                EditPart part = (EditPart)parts.get(i);
                Object model = part.getModel();
                if (model instanceof Node) {
                    EditValidateUtil.validNode((Node)model);
                    Node parent = ((Node)model).getParentNode();
                    model = parent.removeChild((Node)model);
                    result.add(model);
                }
                ++i;
            }
            this.setClipboard(result);
        }
    }

    @Override
    protected ISelection getAfterCommandDesignerSelection() {
        return null;
    }

    public CutNodeCommand(IHTMLGraphicalViewer viewer) {
        super(COMMAND_LABEL, viewer);
    }

    private void setClipboard(Vector result) {
        Node[] nodes = result.toArray(new Node[result.size()]);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int size = nodes.length;
        while (i < size) {
            DOMUtil.nodeToString(nodes[i], sb);
            ++i;
        }
        Clipboard board = new Clipboard(this._viewer.getControl().getDisplay());
        board.setContents(new Object[]{result, sb.toString()}, new Transfer[]{TemplateTransfer.getInstance(), TextTransfer.getInstance()});
    }
}

