/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.impl.resource.EMFTVMResourceImpl;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;

public class ClassModuleResolver
implements ModuleResolver {
    private final Class<?> clazz;

    public ClassModuleResolver(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Module resolveModule(String module) throws ModuleNotFoundException {
        EMFTVMResourceImpl moduleRes = new EMFTVMResourceImpl();
        String moduleFile = String.valueOf(module.replaceAll("::", "/")) + ".emftvm";
        URL moduleUrl = this.clazz.getResource(moduleFile);
        if (moduleUrl == null) {
            throw new ModuleNotFoundException("Cannot find: [" + moduleFile + "]");
        }
        try {
            InputStream inputStream = moduleUrl.openStream();
            if (inputStream == null) {
                throw new ModuleNotFoundException("Cannot load: [" + moduleFile + "]");
            }
            try {
                moduleRes.load(inputStream, Collections.emptyMap());
                moduleRes.setURI(URI.createURI((String)moduleUrl.toString()));
            }
            finally {
                inputStream.close();
            }
            return (Module)moduleRes.getContents().get(0);
        }
        catch (IOException e) {
            throw new ModuleNotFoundException(e);
        }
    }
}

