/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclParametrizedType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;

public class ASMSequence
extends ASMCollection {
    public static ASMOclType myType = ASMOclParametrizedType.getASMOclParametrizedType("Sequence", ASMSequence.getOclAnyType(), ASMCollection.myType);
    private ArrayList s;

    public ASMSequence() {
        super(myType);
        this.s = new ArrayList();
    }

    public ASMSequence(ASMSequence init) {
        super(myType);
        this.s = new ArrayList(init.s);
    }

    public ASMSequence(Collection init) {
        super(myType);
        this.s = new ArrayList(init);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Sequence {");
        Iterator i = this.s.iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append("}");
        return ret.toString();
    }

    @Override
    public void add(ASMOclAny o) {
        this.s.add(o);
    }

    public void add(int index, ASMOclAny o) {
        this.s.add(index, o);
    }

    public void add(Iterator i) {
        while (i.hasNext()) {
            this.add((ASMOclAny)i.next());
        }
    }

    @Override
    public Iterator iterator() {
        return this.s.iterator();
    }

    @Override
    public Collection collection() {
        return this.s;
    }

    public boolean equals(Object o) {
        return o instanceof ASMSequence && ((ASMSequence)o).s.equals(this.s);
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public static ASMSequence union(StackFrame frame, ASMSequence self, ASMCollection other) {
        ASMSequence ret = new ASMSequence(self);
        ret.s.addAll(other.collection());
        return ret;
    }

    public static ASMSequence flatten(StackFrame frame, ASMSequence self) {
        boolean containsCollection;
        ArrayList<ASMOclAny> base = null;
        ArrayList<ASMOclAny> ret = new ArrayList<ASMOclAny>(self.collection());
        do {
            base = ret;
            ret = new ArrayList();
            containsCollection = false;
            int i = 0;
            while (i < base.size()) {
                ASMOclAny object = (ASMOclAny)base.get(i);
                if (object instanceof ASMCollection) {
                    ASMCollection subCollection = (ASMCollection)object;
                    ret.addAll(subCollection.collection());
                    Iterator iterator = subCollection.iterator();
                    while (!containsCollection && iterator.hasNext()) {
                        ASMOclAny subCollectionObject = (ASMOclAny)iterator.next();
                        if (!(subCollectionObject instanceof ASMCollection)) continue;
                        containsCollection = true;
                    }
                } else {
                    ret.add(object);
                }
                ++i;
            }
        } while (containsCollection);
        return new ASMSequence(ret);
    }

    public static ASMSequence append(StackFrame frame, ASMSequence self, ASMOclAny o) {
        return ASMSequence.including(frame, self, o);
    }

    public static ASMSequence prepend(StackFrame frame, ASMSequence self, ASMOclAny o) {
        return ASMSequence.insertAt(frame, self, new ASMInteger(1), o);
    }

    public static ASMSequence insertAt(StackFrame frame, ASMSequence self, ASMInteger index, ASMOclAny o) {
        ASMSequence ret = new ASMSequence(self);
        ret.s.add(index.getSymbol() - 1, o);
        return ret;
    }

    public static ASMSequence subSequence(StackFrame frame, ASMSequence self, ASMInteger lower, ASMInteger upper) {
        ASMSequence ret = new ASMSequence();
        int l = lower.getSymbol();
        int u = upper.getSymbol();
        int k = 1;
        Iterator i = self.iterator();
        while (i.hasNext() && k <= u) {
            ASMOclAny object = (ASMOclAny)i.next();
            if (k >= l) {
                ret.add(object);
            }
            ++k;
        }
        return ret;
    }

    public static ASMOclAny at(StackFrame frame, ASMSequence self, ASMInteger i) {
        return (ASMOclAny)self.s.get(i.getSymbol() - 1);
    }

    public static ASMInteger indexOf(StackFrame frame, ASMSequence self, ASMOclAny o) {
        return new ASMInteger(self.s.indexOf(o) + 1);
    }

    public static ASMOclAny first(StackFrame frame, ASMSequence self) {
        return self.s.size() == 0 ? new ASMOclUndefined() : (ASMOclAny)self.s.get(0);
    }

    public static ASMOclAny last(StackFrame frame, ASMSequence self) {
        return self.s.size() == 0 ? new ASMOclUndefined() : (ASMOclAny)self.s.get(self.s.size() - 1);
    }

    public static ASMSequence including(StackFrame frame, ASMSequence self, ASMOclAny o) {
        ASMSequence ret = new ASMSequence(self);
        ret.s.add(o);
        return ret;
    }

    public static ASMSequence excluding(StackFrame frame, ASMSequence self, ASMOclAny o) {
        ASMSequence ret = new ASMSequence(self);
        ret.s.removeAll(Arrays.asList(o));
        return ret;
    }

    public static ASMSequence asSequence(StackFrame frame, ASMSequence self) {
        return self;
    }
}

