/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalAstWalker;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeLoopExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;

public class ValidBreakpointLocator {
    private ValidBreakpointLocator() {
    }

    public static List<ASTNode> getBreakpointableElementsForLine(CompiledUnit compiledModule, LineNumberProvider lineNumbers, int lineNumber) {
        BreakpointableNodeLocator locator = new BreakpointableNodeLocator(lineNumber, lineNumbers);
        QvtOperationalAstWalker walker = new QvtOperationalAstWalker((QvtOperationalAstWalker.NodeProcessor)locator);
        for (Module nextModule : compiledModule.getModules()) {
            nextModule.accept((Visitor)walker);
            List elements = locator.elements;
            if (elements.isEmpty()) continue;
            return elements;
        }
        return Collections.emptyList();
    }

    static boolean isBreakpointableElementStart(ASTNode element) {
        boolean breakpointable;
        boolean bl = breakpointable = (element instanceof OCLExpression || element instanceof ObjectExp || element instanceof AssignExp || element instanceof BreakExp || element instanceof ContinueExp || element instanceof VariableInitExp) && !(element instanceof BlockExp) && !(element instanceof ImperativeIterateExp) && !(element instanceof IteratorExp) && !(element instanceof ContextualProperty) && !(element instanceof ImperativeLoopExp);
        if (breakpointable && element instanceof ObjectExp && element.eContainer() instanceof MappingBody && element.eContainingFeature() == ExpressionsPackage.eINSTANCE.getOperationBody_Content()) {
            MappingBody mappingBody = (MappingBody)element.eContainer();
            ObjectExp objectExp = (ObjectExp)element;
            return mappingBody.getStartPosition() != objectExp.getStartPosition();
        }
        return breakpointable;
    }

    static boolean isBreakpointableElementEnd(ASTNode element) {
        EOperation referredOperation = null;
        if (element instanceof OperationCallExp) {
            referredOperation = (EOperation)((OperationCallExp)element).getReferredOperation();
        }
        boolean breakpointable = element instanceof ImperativeOperation || element instanceof MappingCallExp || referredOperation instanceof ImperativeOperation;
        return breakpointable;
    }

    private static final class BreakpointableNodeLocator
    implements QvtOperationalAstWalker.NodeProcessor {
        private final List<ASTNode> elements = new ArrayList<ASTNode>();
        private final int lineNumber;
        private final LineNumberProvider lineNumbers;

        BreakpointableNodeLocator(int lineNumber, LineNumberProvider lineNumbers) {
            this.lineNumber = lineNumber;
            this.lineNumbers = lineNumbers;
        }

        public void process(Visitable visitable, Visitable parent) {
            int line;
            if (!(visitable instanceof ASTNode)) {
                return;
            }
            ASTNode astNode = (ASTNode)visitable;
            boolean found = false;
            if (ValidBreakpointLocator.isBreakpointableElementStart(astNode) && (line = this.lineNumbers.getLineNumber(astNode.getStartPosition())) == this.lineNumber) {
                this.elements.add(astNode);
                found = true;
            }
            if (!found && ValidBreakpointLocator.isBreakpointableElementEnd(astNode) && (line = this.lineNumbers.getLineNumber(astNode.getEndPosition())) == this.lineNumber) {
                this.elements.add(astNode);
            }
        }
    }
}

