/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.externalization.AbstractExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationContext;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;

public class ActivityExternalizationParticipant
extends AbstractExternalizationParticipant
implements ITaskActivityListener {
    private boolean isDirty = false;
    private final ExternalizationManager manager;
    private long lastUpdate;

    public ActivityExternalizationParticipant(ExternalizationManager manager) {
        this.manager = manager;
        MonitorUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(event -> {
            if (event.getProperty().equals("org.eclipse.mylyn.monitor.activity.tracking.enabled")) {
                this.requestSave();
            }
        });
    }

    public void execute(IExternalizationContext context, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        switch (context.getKind()) {
            case SAVE: {
                if (ContextCorePlugin.getDefault() == null || !MonitorUiPlugin.getDefault().isActivityTrackingEnabled() || ContextCorePlugin.getContextManager() == null) break;
                this.setDirty(false);
                ContextCorePlugin.getContextManager().saveActivityMetaContext();
                break;
            }
            case LOAD: {
                ContextCorePlugin.getContextManager().loadActivityMetaContext();
                break;
            }
        }
    }

    public String getDescription() {
        return Messages.ActivityExternalizationParticipant_Activity_Context;
    }

    public ISchedulingRule getSchedulingRule() {
        return ITasksCoreConstants.ACTIVITY_SCHEDULING_RULE;
    }

    public boolean isDirty() {
        return this.isDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(boolean full) {
        ActivityExternalizationParticipant activityExternalizationParticipant = this;
        synchronized (activityExternalizationParticipant) {
            return this.isDirty || full;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean dirty) {
        ActivityExternalizationParticipant activityExternalizationParticipant = this;
        synchronized (activityExternalizationParticipant) {
            this.isDirty = dirty;
        }
    }

    public String getFileName() {
        return null;
    }

    public void load(File sourceFile, IProgressMonitor monitor) throws CoreException {
    }

    public void save(File targetFile, IProgressMonitor monitor) throws CoreException {
    }

    public void activityReset() {
    }

    public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
        if (System.currentTimeMillis() - this.lastUpdate > 60000L) {
            this.requestSave();
        }
    }

    private void requestSave() {
        this.setDirty(true);
        this.manager.requestSave();
        this.lastUpdate = System.currentTimeMillis();
    }
}

