/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class RewriteBindThis
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    AbstractCompiler compiler;

    RewriteBindThis(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (node.isFunction() && this.canRewriteBinding(node)) {
            this.rewriteBinding(node);
        }
    }

    private boolean hasBindThisCall(Node functionNode) {
        Node parentNode = functionNode.getParent();
        return parentNode.isGetProp() && functionNode.getNext().getString().equals("bind") && parentNode.getParent().isCall() && parentNode.getNext().isThis();
    }

    private boolean canRewriteBinding(Node functionNode) {
        return functionNode.getFirstChild().getString().isEmpty() && this.hasBindThisCall(functionNode) && !NodeUtil.isVarArgsFunction(functionNode);
    }

    private void rewriteBinding(Node functionNode) {
        Node parent = functionNode.getParent();
        Node grandparent = parent.getParent();
        parent.removeChild(functionNode);
        grandparent.getParent().replaceChild(grandparent, functionNode);
        functionNode.putBooleanProp(60, true);
        this.compiler.reportCodeChange();
    }
}

