/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathWizard;
import org.eclipse.dltk.internal.ui.wizards.buildpath.SetFilterWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public class EditFilterWizard
extends BuildPathWizard {
    private SetFilterWizardPage fFilterPage;
    private final IPath[] fOrginalInclusion;
    private final IPath[] fOriginalExclusion;

    public EditFilterWizard(BPListElement[] existingEntries, BPListElement newEntry) {
        super(existingEntries, newEntry, NewWizardMessages.ExclusionInclusionDialog_title, null);
        IPath[] inc = (IPath[])newEntry.getAttribute("inclusion");
        this.fOrginalInclusion = new IPath[inc.length];
        System.arraycopy(inc, 0, this.fOrginalInclusion, 0, inc.length);
        IPath[] excl = (IPath[])newEntry.getAttribute("exclusion");
        this.fOriginalExclusion = new IPath[excl.length];
        System.arraycopy(excl, 0, this.fOriginalExclusion, 0, excl.length);
    }

    public void addPages() {
        super.addPages();
        this.fFilterPage = new SetFilterWizardPage(this.getEntryToEdit(), this.getExistingEntries());
        this.addPage((IWizardPage)this.fFilterPage);
    }

    @Override
    public boolean performFinish() {
        BPListElement entryToEdit = this.getEntryToEdit();
        entryToEdit.setAttribute("inclusion", this.fFilterPage.getInclusionPattern());
        entryToEdit.setAttribute("exclusion", this.fFilterPage.getExclusionPattern());
        return super.performFinish();
    }

    @Override
    public void cancel() {
        BPListElement entryToEdit = this.getEntryToEdit();
        entryToEdit.setAttribute("inclusion", this.fOrginalInclusion);
        entryToEdit.setAttribute("exclusion", this.fOriginalExclusion);
    }
}

