/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOSessionInvalidationEventQueue {
    private CDOSession session;
    private IListener sessionListener = new IListener(){

        public void notifyEvent(IEvent event) {
            try {
                if (event instanceof CDOSessionInvalidationEvent) {
                    CDOSessionInvalidationEvent e = (CDOSessionInvalidationEvent)event;
                    CDOSessionInvalidationEventQueue.this.handleEvent(e);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    };
    private Queue<CDOSessionInvalidationEvent> queue = new LinkedList<CDOSessionInvalidationEvent>();

    public CDOSessionInvalidationEventQueue(CDOSession session) {
        this.session = session;
        session.addListener(this.sessionListener);
    }

    public void dispose() {
        this.reset();
        this.session.removeListener(this.sessionListener);
        this.session = null;
    }

    public CDOSession getSession() {
        return this.session;
    }

    @Deprecated
    public CDOChangeSetData getChangeSetData() {
        return this.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOSessionInvalidationEvent poll() {
        Queue<CDOSessionInvalidationEvent> queue = this.queue;
        synchronized (queue) {
            return this.queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOSessionInvalidationEvent remove(long timestamp) {
        Queue<CDOSessionInvalidationEvent> queue = this.queue;
        synchronized (queue) {
            Iterator it = this.queue.iterator();
            while (it.hasNext()) {
                CDOSessionInvalidationEvent event = (CDOSessionInvalidationEvent)it.next();
                if (event.getTimeStamp() != timestamp) continue;
                it.remove();
                return event;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Queue<CDOSessionInvalidationEvent> queue = this.queue;
        synchronized (queue) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEvent(CDOSessionInvalidationEvent event) throws Exception {
        Queue<CDOSessionInvalidationEvent> queue = this.queue;
        synchronized (queue) {
            this.queue.offer(event);
        }
    }
}

