/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.BasicColorProvider;
import org.eclipse.draw2d.ColorProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GEFColorProvider;
import org.eclipse.gef.internal.Logger;
import org.eclipse.gef.internal.LoggerContext;
import org.eclipse.gef.util.IToolTipHelperFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class InternalGEFPlugin
extends AbstractUIPlugin {
    public static final String MONITOR_SCALE_PROPERTY = "monitorScale";
    private static BundleContext context;
    private static AbstractUIPlugin singleton;
    private static Boolean requiresDisabledIcons;
    private static Collection<ServiceReference<IToolTipHelperFactory>> toolTipProviderRefs;
    private static Collection<IToolTipHelperFactory> toolTipProviders;

    public InternalGEFPlugin() {
        singleton = this;
    }

    public void start(BundleContext bc) throws Exception {
        super.start(bc);
        context = bc;
        if (ColorProvider.SystemColorFactory.getColorProvider() instanceof BasicColorProvider && PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isClosing()) {
            ColorProvider.SystemColorFactory.setColorProvider((ColorProvider)new GEFColorProvider());
        }
        toolTipProviders = new ArrayList<IToolTipHelperFactory>();
        toolTipProviderRefs = bc.getServiceReferences(IToolTipHelperFactory.class, null);
        for (ServiceReference<IToolTipHelperFactory> toolTipProviderRef : toolTipProviderRefs) {
            toolTipProviders.add((IToolTipHelperFactory)bc.getService(toolTipProviderRef));
        }
        Logger.setContext((org.eclipse.draw2d.internal.LoggerContext)new LoggerContext());
    }

    public void stop(BundleContext bc) throws Exception {
        toolTipProviders.clear();
        for (ServiceReference<IToolTipHelperFactory> toolTipProviderRef : toolTipProviderRefs) {
            bc.ungetService(toolTipProviderRef);
        }
        super.stop(bc);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
    }

    public static BundleContext getContext() {
        return context;
    }

    public static AbstractUIPlugin getDefault() {
        return singleton;
    }

    public static int getOrDefaultDeviceZoom() {
        if (Platform.getOS().equals("macosx") || Platform.getOS().equals("linux") && "x11".equalsIgnoreCase(System.getenv("XDG_SESSION_TYPE"))) {
            return 100;
        }
        String deviceZoom = System.getProperty("org.eclipse.swt.internal.deviceZoom", "100");
        try {
            return Integer.parseInt(deviceZoom);
        }
        catch (NumberFormatException e) {
            return 100;
        }
    }

    public static Collection<IToolTipHelperFactory> getToolTipHelperFactories() {
        return Collections.unmodifiableCollection(toolTipProviders);
    }

    public static ImageData scaledImageData(ImageDescriptor descriptor, int zoom) {
        ImageData data = descriptor.getImageData(zoom);
        if (data != null) {
            return data;
        }
        Image image = descriptor.createImage();
        try {
            ImageData imageData = image.getImageData(zoom);
            return imageData;
        }
        finally {
            image.dispose();
        }
    }

    public static Cursor createCursor(ImageDescriptor source, int hotspotX, int hotspotY) {
        try {
            ImageDataProvider provider = zoom -> {
                if (zoom < 150) {
                    return source.getImageData(100);
                }
                if (zoom < 200) {
                    return source.getImageData(150);
                }
                return source.getImageData(200);
            };
            Constructor ctor = Cursor.class.getConstructor(Device.class, ImageDataProvider.class, Integer.TYPE, Integer.TYPE);
            return (Cursor)ctor.newInstance(null, provider, hotspotX, hotspotY);
        }
        catch (NoSuchMethodException e) {
            return new Cursor(null, source.getImageData(100), hotspotX, hotspotY);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Cursor", e);
        }
    }

    public static EditPartListener createAutoscaleEditPartListener(final Consumer<Double> consumer) {
        final PropertyChangeListener autoScaleListener = evt -> {
            if (MONITOR_SCALE_PROPERTY.equals(evt.getPropertyName()) && evt.getNewValue() != null) {
                double newValue = (Double)evt.getNewValue();
                consumer.accept(newValue);
            }
        };
        return new EditPartListener.Stub(){

            @Override
            public void partActivated(EditPart editpart) {
                editpart.getViewer().addPropertyChangeListener(autoScaleListener);
                try {
                    double scale = (Double)editpart.getViewer().getProperty(InternalGEFPlugin.MONITOR_SCALE_PROPERTY);
                    consumer.accept(scale);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }

            @Override
            public void partDeactivated(EditPart editpart) {
                editpart.getViewer().removePropertyChangeListener(autoScaleListener);
            }
        };
    }

    public static boolean requiresDisabledIcon() {
        if (requiresDisabledIcons == null) {
            Version minVersion = new Version(3, 130, 0);
            requiresDisabledIcons = FrameworkUtil.getBundle(SWT.class).getVersion().compareTo(minVersion) < 0;
        }
        return requiresDisabledIcons;
    }
}

