/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyle;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyleRegion;
import org.eclipse.graphiti.mm.algorithms.styles.UnderlineStyle;

public class TextBuilder {
    private StringBuilder text = new StringBuilder();
    private int length = 0;
    private List<TextStyleRegion> regions = new ArrayList<TextStyleRegion>();
    private Map<String, TextBuilderRegion> styles = new LinkedHashMap<String, TextBuilderRegion>();

    public void add(String text) {
        this.length += text.length();
        this.text.append(text);
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return this.text.toString();
    }

    public List<TextStyleRegion> getRegions() {
        return this.regions;
    }

    public TextBuilderRegion startRegion(String name) {
        TextBuilderRegion tbr = new TextBuilderRegion().setStart(this.length);
        this.styles.put(name, tbr);
        return tbr;
    }

    public TextBuilderRegion getRegion(String name) {
        return this.styles.get(name);
    }

    public void finishRegion(String name) {
        TextBuilderRegion region = this.styles.get(name);
        this.styles.remove(name);
        if (region != null && region.getStyle() != null) {
            TextStyleRegion styleRegion = StylesFactory.eINSTANCE.createTextStyleRegion();
            styleRegion.setStart(region.getStart());
            styleRegion.setStyle(region.getStyle());
            styleRegion.setEnd(this.length);
            this.regions.add(styleRegion);
        }
    }

    public void forgetRegion(String name) {
        this.styles.remove(name);
    }

    public static class TextBuilderRegion {
        private TextStyle style = null;
        private int start = 0;

        public int getStart() {
            return this.start;
        }

        public TextStyle getStyle() {
            return this.style;
        }

        private void ensureStyle() {
            if (this.style == null) {
                this.style = StylesFactory.eINSTANCE.createTextStyle();
            }
        }

        public TextBuilderRegion setStyle(TextStyle style) {
            this.style = style;
            return this;
        }

        public TextBuilderRegion setStart(int start) {
            this.start = start;
            return this;
        }

        public TextBuilderRegion setUnderline(UnderlineStyle uStyle, Color col) {
            this.ensureStyle();
            if (uStyle == null) {
                this.style.setUnderline(false);
            } else {
                this.style.setUnderline(true);
                this.style.setUnderlineStyle(uStyle);
            }
            this.setUnderline(col);
            return this;
        }

        public TextBuilderRegion setUnderline(Color col) {
            this.ensureStyle();
            if (col != null && this.style.isUnderline()) {
                this.style.setUnderlineColor(col);
            }
            return this;
        }

        public TextBuilderRegion setStrikeOut(boolean value, Color col) {
            this.ensureStyle();
            this.style.setStrikeout(value);
            if (value && col != null) {
                this.style.setStrikeoutColor(col);
            }
            return this;
        }

        public TextBuilderRegion setForeground(Color col) {
            this.ensureStyle();
            if (col != null) {
                this.style.setForeground(col);
            }
            return this;
        }

        public TextBuilderRegion setBackground(Color col) {
            this.ensureStyle();
            if (col != null) {
                this.style.setBackground(col);
            }
            return this;
        }

        public TextBuilderRegion setFont(Font font) {
            this.ensureStyle();
            this.style.setFont(font);
            return this;
        }
    }
}

