/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSHandlerUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.wizards.AddHandlerChainPage;
import org.eclipse.jst.ws.internal.jaxws.ui.wizards.OrderHandlerChainPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.jdom.Document;

public class ConfigureHandlerWizard
extends Wizard {
    private AddHandlerChainPage addHandlerChainPage;
    private OrderHandlerChainPage orderHandlerChainPage;
    private boolean fileCreated;
    private boolean addAnnotation;
    private IPath handlerChainPath;
    private IType type;

    public ConfigureHandlerWizard(IType type) {
        this.type = type;
        this.setWindowTitle(JAXWSUIMessages.JAXWS_CONFIGURE_HANDLER_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(JAXWSUIPlugin.getImageDescriptor("$nl$/icons/wizban/new_wiz.png"));
        this.handlerChainPath = this.getHandlerChainPath(type);
    }

    public void addPages() {
        if (this.addHandlerChainPage == null) {
            this.addHandlerChainPage = new AddHandlerChainPage(this.type);
        }
        if (this.orderHandlerChainPage == null) {
            this.orderHandlerChainPage = new OrderHandlerChainPage(this.handlerChainPath, this.type.getJavaProject());
        }
        if (this.handlerChainPath != null && this.handlerChainPath.isEmpty()) {
            this.addPage((IWizardPage)this.addHandlerChainPage);
        }
        this.addPage((IWizardPage)this.orderHandlerChainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.addHandlerChainPage && this.addHandlerChainPage.isPageComplete()) {
            if (this.addHandlerChainPage.isCreateHandlerChain()) {
                this.handlerChainPath = new Path(this.addHandlerChainPage.getNewHandlerChainPath());
                this.orderHandlerChainPage.setHandlerChainPath(this.handlerChainPath);
                this.addAnnotation = true;
                this.fileCreated = true;
                this.addHandlerChainPage.setFileCreated(this.fileCreated);
            }
            if (this.addHandlerChainPage.isEditHandlerChain()) {
                this.handlerChainPath = new Path(this.addHandlerChainPage.getExistingHandlerChainPath());
                this.orderHandlerChainPage.setHandlerChainPath(this.handlerChainPath);
                this.addAnnotation = true;
                this.fileCreated = false;
                this.addHandlerChainPage.setFileCreated(this.fileCreated);
            }
        }
        return super.getNextPage(page);
    }

    private IPath getHandlerChainPath(IType type) {
        String file;
        Annotation handlerChain;
        if (type != null && (handlerChain = AnnotationUtils.getAnnotation((IJavaElement)type, HandlerChain.class)) != null && (file = AnnotationUtils.getStringValue((Annotation)handlerChain, (String)"file")) != null) {
            if (!file.startsWith("../")) {
                return type.getPackageFragment().getPath().append((IPath)new Path(file));
            }
            return this.findHandlerChainPath(file);
        }
        return Path.EMPTY;
    }

    private IPath findHandlerChainPath(String file) {
        IContainer container = this.type.getResource().getParent();
        if (container != null) {
            IResource handlerChainFile;
            while (file.startsWith("../")) {
                file = file.substring(3);
                if (container == null) continue;
                container = container.getParent();
            }
            if (container != null && (handlerChainFile = container.findMember(file)) != null) {
                return handlerChainFile.getFullPath();
            }
        }
        return Path.EMPTY;
    }

    public boolean performFinish() {
        try {
            Object rule = null;
            Job job = Job.getJobManager().currentJob();
            rule = job != null ? job.getRule() : ResourcesPlugin.getWorkspace().getRoot();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((ISchedulingRule)rule){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    if (ConfigureHandlerWizard.this.addAnnotation) {
                        IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(ConfigureHandlerWizard.this.handlerChainPath);
                        URI relativeURI = URI.createPlatformResourceURI((String)handlerChainFile.getLocation().toOSString(), (boolean)false).deresolve(URI.createPlatformResourceURI((String)ConfigureHandlerWizard.this.type.getResource().getLocation().toOSString(), (boolean)false));
                        ICompilationUnit compilationUnit = ConfigureHandlerWizard.this.type.getCompilationUnit();
                        ASTParser parser = ASTParser.newParser((int)3);
                        parser.setSource(compilationUnit);
                        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
                        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
                        MemberValuePair filePair = AnnotationsCore.createStringMemberValuePair((AST)cu.getAST(), (String)"file", (String)relativeURI.toFileString());
                        memberValuePairs.add(filePair);
                        NormalAnnotation handlerChainAnnotation = AnnotationsCore.createNormalAnnotation((AST)cu.getAST(), (String)HandlerChain.class.getSimpleName(), memberValuePairs);
                        AnnotationUtils.addAnnotation((IJavaElement)ConfigureHandlerWizard.this.type, (Annotation)handlerChainAnnotation);
                        AnnotationUtils.addImport((IJavaElement)ConfigureHandlerWizard.this.type, (String)HandlerChain.class.getCanonicalName());
                    }
                    JAXWSHandlerUtils.writeDocumentToFile((IPath)ConfigureHandlerWizard.this.handlerChainPath, (Document)ConfigureHandlerWizard.this.orderHandlerChainPage.getDocument());
                }
            };
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)workspaceModifyOperation, rule);
        }
        catch (InvocationTargetException ite) {
            JAXWSUIPlugin.log(ite);
            return false;
        }
        catch (InterruptedException ie) {
            JAXWSUIPlugin.log(ie);
            return false;
        }
        return true;
    }

    public void deleteFile(IPath filePath) {
        IFile handlerFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        if (handlerFile.exists()) {
            try {
                handlerFile.delete(true, null);
            }
            catch (CoreException ce) {
                JAXWSUIPlugin.log(ce.getStatus());
            }
        }
    }

    public boolean performCancel() {
        if (this.fileCreated) {
            IPath filePath = this.type.getPackageFragment().getPath().append((IPath)new Path("handler-chain.xml"));
            this.deleteFile(filePath);
        }
        return super.performCancel();
    }
}

