/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.earmodules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.m2e.wtp.earmodules.EarPluginException;
import org.eclipse.m2e.wtp.earmodules.UnknownArtifactTypeException;

public class ArtifactTypeMappingService {
    static final String ARTIFACT_TYPE_MAPPING_ELEMENT = "artifactTypeMapping";
    static final String TYPE_ATTRIBUTE = "type";
    static final String MAPPING_ATTRIBUTE = "mapping";
    public static final List<String> standardArtifactTypes = new ArrayList<String>(10);
    private Map<String, List<String>> typeMappings;
    private Map<String, String> customMappings;

    static {
        standardArtifactTypes.add("jar");
        standardArtifactTypes.add("ejb");
        standardArtifactTypes.add("ejb3");
        standardArtifactTypes.add("par");
        standardArtifactTypes.add("ejb-client");
        standardArtifactTypes.add("rar");
        standardArtifactTypes.add("war");
        standardArtifactTypes.add("sar");
        standardArtifactTypes.add("wsr");
        standardArtifactTypes.add("har");
        standardArtifactTypes.add("app-client");
    }

    public ArtifactTypeMappingService(Xpp3Dom plexusConfiguration) throws EarPluginException {
        Xpp3Dom[] artifactTypeMappings;
        this.init();
        if (plexusConfiguration == null) {
            return;
        }
        Xpp3Dom[] xpp3DomArray = artifactTypeMappings = plexusConfiguration.getChildren(ARTIFACT_TYPE_MAPPING_ELEMENT);
        int n = artifactTypeMappings.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom artifactTypeMapping = xpp3DomArray[n2];
            String customType = artifactTypeMapping.getAttribute(TYPE_ATTRIBUTE);
            String mapping = artifactTypeMapping.getAttribute(MAPPING_ATTRIBUTE);
            if (customType == null) {
                throw new EarPluginException("Invalid artifact type mapping, type attribute should be set.");
            }
            if (mapping == null) {
                throw new EarPluginException("Invalid artifact type mapping, mapping attribute should be set.");
            }
            if (!ArtifactTypeMappingService.isStandardArtifactType(mapping)) {
                throw new EarPluginException("Invalid artifact type mapping, mapping[" + mapping + "] must be a standard Ear artifact type[" + String.valueOf(ArtifactTypeMappingService.getStandardArtifactTypes()) + "]");
            }
            if (this.customMappings.containsKey(customType)) {
                throw new EarPluginException("Invalid artifact type mapping, type[" + customType + "] is already registered.");
            }
            this.customMappings.put(customType, mapping);
            List<String> typeMapping = this.typeMappings.get(mapping);
            typeMapping.add(customType);
            ++n2;
        }
    }

    public boolean isMappedToType(String standardType, String customType) {
        if (!ArtifactTypeMappingService.isStandardArtifactType(standardType)) {
            throw new IllegalStateException("Artifact type[" + standardType + "] is not a standard Ear artifact type[" + String.valueOf(ArtifactTypeMappingService.getStandardArtifactTypes()) + "]");
        }
        List<String> typeMappings = this.typeMappings.get(standardType);
        return typeMappings.contains(customType);
    }

    public String getStandardType(String type) throws UnknownArtifactTypeException {
        if (type == null) {
            throw new IllegalStateException("custom type could not be null.");
        }
        if (ArtifactTypeMappingService.getStandardArtifactTypes().contains(type)) {
            return type;
        }
        if (!this.customMappings.containsKey(type)) {
            throw new UnknownArtifactTypeException("Unknown artifact type[" + type + "]");
        }
        return this.customMappings.get(type);
    }

    private void init() {
        this.typeMappings = new HashMap<String, List<String>>();
        this.customMappings = new HashMap<String, String>();
        for (String type : ArtifactTypeMappingService.getStandardArtifactTypes()) {
            ArrayList<String> typeMapping = new ArrayList<String>();
            typeMapping.add(type);
            this.typeMappings.put(type, typeMapping);
        }
    }

    public static List<String> getStandardArtifactTypes() {
        return standardArtifactTypes;
    }

    public static boolean isStandardArtifactType(String type) {
        return standardArtifactTypes.contains(type);
    }
}

