/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.DiagnosticUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxMessages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.qvt.oml.blackbox.java.JavaModelInstance;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;

class Java2QVTTypeResolver {
    static final int STRICT_TYPE = 1;
    static final int ALLOW_SUBTYPE = 2;
    static final int ALLOW_SUPERTYPE = 4;
    private QvtOperationalModuleEnv fEnv;
    private Collection<String> fPackageURIs;
    private EClassifier fHelperEClassiferAdapter;
    private BasicDiagnostic fDiagnostics;
    private Map<String, URI> genModelMap;
    private Map<EPackage, ModelContent> genModelContentsMap = new HashMap<EPackage, ModelContent>();
    private static final Comparator<EClassifier> HIERARCHY_COMPARATOR_ASC = new Comparator<EClassifier>(){

        @Override
        public int compare(EClassifier o1, EClassifier o2) {
            Class o1Class = o1.getInstanceClass();
            Class o2Class = o2.getInstanceClass();
            if (o2Class.equals(o1Class)) {
                return 0;
            }
            if (o1Class.isAssignableFrom(o2Class)) {
                return -1;
            }
            if (o2Class.isAssignableFrom(o1Class)) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<EClassifier> HIERARCHY_COMPARATOR_DESC = new Comparator<EClassifier>(){

        @Override
        public int compare(EClassifier o1, EClassifier o2) {
            Class o1Class = o1.getInstanceClass();
            Class o2Class = o2.getInstanceClass();
            if (o2Class.equals(o1Class)) {
                return 0;
            }
            if (o1Class.isAssignableFrom(o2Class)) {
                return 1;
            }
            if (o2Class.isAssignableFrom(o1Class)) {
                return -1;
            }
            return 0;
        }
    };

    Java2QVTTypeResolver(QvtOperationalModuleEnv env, Collection<String> packageURIs, BasicDiagnostic diagnostics) {
        this.fEnv = env;
        this.fPackageURIs = packageURIs;
        this.fDiagnostics = diagnostics;
    }

    QvtOperationalModuleEnv getEnvironment() {
        return this.fEnv;
    }

    EClassifier toEClassifier(Type type, int relationship) {
        EClassifier result = this.type2EClassifier(type, relationship);
        if (result == null) {
            if (type instanceof Class) {
                EClassifier eWrapper = this.asEClassifier((Class)type);
                EClassifier asOCLType = (EClassifier)this.fEnv.getUMLReflection().asOCLType((Object)eWrapper);
                if (asOCLType != eWrapper) {
                    return asOCLType;
                }
            }
        } else {
            return (EClassifier)this.fEnv.getUMLReflection().asOCLType((Object)result);
        }
        return result;
    }

    private EClassifier type2EClassifier(Type type, int relationship) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.handleParameterizedType(parameterizedType, relationship);
        }
        if (type instanceof Class) {
            return this.handleType((Class)type, relationship);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            OCLStandardLibrary stdLib = this.fEnv.getOCLStandardLibrary();
            if (((EClassifier)stdLib.getT()).getName().equals(typeVariable.getName())) {
                return (EClassifier)this.getEnvironment().getOCLStandardLibrary().getT();
            }
            if (((EClassifier)stdLib.getT2()).getName().equals(typeVariable.getName())) {
                return (EClassifier)this.getEnvironment().getOCLStandardLibrary().getT();
            }
            if (QvtOperationalStdLibrary.INSTANCE.getKeyT().getName().equals(typeVariable.getName())) {
                return QvtOperationalStdLibrary.INSTANCE.getKeyT();
            }
        }
        return null;
    }

    private EClassifier handleParameterizedType(ParameterizedType parameterizedType, int relationship) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return null;
        }
        Type actualElementType = actualTypeArguments[0];
        if (!(rawType instanceof Class)) {
            return null;
        }
        Class rawClass = (Class)rawType;
        if (rawClass == Dictionary.class) {
            EClassifier elementType;
            Type actualElementType2;
            EClassifier keyType = this.toEClassifier(actualElementType, relationship);
            Type type = actualElementType2 = actualTypeArguments.length > 1 ? actualTypeArguments[1] : null;
            if (keyType != null && actualElementType2 != null && (elementType = this.toEClassifier(actualElementType2, relationship)) != null) {
                return this.fEnv.getTypeResolver().resolveDictionaryType(keyType, elementType);
            }
        } else if (rawClass == MutableList.class) {
            EClassifier listElementType = this.toEClassifier(actualElementType, relationship);
            if (listElementType != null) {
                return this.fEnv.getTypeResolver().resolveListType(listElementType);
            }
        } else {
            if (rawClass == LinkedHashSet.class) {
                return this.resolveCollectionType(CollectionKind.ORDERED_SET_LITERAL, actualElementType, relationship);
            }
            if (Set.class.isAssignableFrom(rawClass)) {
                return this.resolveCollectionType(CollectionKind.SET_LITERAL, actualElementType, relationship);
            }
            if (rawClass == Bag.class) {
                return this.resolveCollectionType(CollectionKind.BAG_LITERAL, actualElementType, relationship);
            }
            if (List.class.isAssignableFrom(rawClass)) {
                return this.resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, actualElementType, relationship);
            }
            if (rawType == List.class) {
                return this.resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, actualElementType, relationship);
            }
            if (rawType == Collection.class) {
                return this.resolveCollectionType(CollectionKind.COLLECTION_LITERAL, actualElementType, relationship);
            }
        }
        return this.lookupByInstanceClass(parameterizedType, relationship);
    }

    private EClassifier resolveCollectionType(CollectionKind kind, Type elementType, int relationship) {
        QVTOTypeResolver typeResolver = this.fEnv.getTypeResolver();
        EClassifier actualElementClassifier = null;
        if (elementType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)elementType;
            String genericJavaTypeName = typeVariable.getName();
            OCLStandardLibrary oclStdLibrary = this.fEnv.getOCLStandardLibrary();
            EClassifier typeT = (EClassifier)oclStdLibrary.getT();
            if (typeT.getName().equals(genericJavaTypeName)) {
                actualElementClassifier = typeT;
            } else {
                EClassifier typeT2 = (EClassifier)oclStdLibrary.getT2();
                if (typeT2.getName().equals(genericJavaTypeName)) {
                    actualElementClassifier = typeT2;
                }
            }
        } else if (elementType != null) {
            actualElementClassifier = this.toEClassifier(elementType, relationship);
        }
        if (actualElementClassifier != null) {
            return (EClassifier)typeResolver.resolveCollectionType(kind, actualElementClassifier);
        }
        return null;
    }

    private EClassifier handleType(Class<?> type, int relationship) {
        OCLStandardLibrary stdLibrary = this.fEnv.getOCLStandardLibrary();
        if (type == Object.class) {
            return (EClassifier)stdLibrary.getOclAny();
        }
        if (type == String.class) {
            return (EClassifier)stdLibrary.getString();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (EClassifier)stdLibrary.getBoolean();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (EClassifier)stdLibrary.getInteger();
        }
        if (type == Double.class || type == Double.TYPE) {
            return (EClassifier)stdLibrary.getReal();
        }
        if (type == Void.TYPE) {
            return (EClassifier)stdLibrary.getOclVoid();
        }
        if (type == JavaModelInstance.class) {
            return this.fEnv.getQVTStandardLibrary().getModelClass();
        }
        return this.lookupByInstanceClass(type, relationship);
    }

    private EClassifier lookupByInstanceClass(Class<?> type, int relationship) {
        assert (type != null);
        TreeSet<EClassifier> subtypes = new TreeSet<EClassifier>(HIERARCHY_COMPARATOR_DESC);
        TreeSet<EClassifier> supertypes = new TreeSet<EClassifier>(HIERARCHY_COMPARATOR_ASC);
        Set packageURIs = this.fPackageURIs.isEmpty() ? this.fEnv.getEPackageRegistry().keySet() : this.fPackageURIs;
        for (String nsURI : packageURIs) {
            EPackage ePackage = this.resolvePackage(nsURI, (DiagnosticChain)this.fDiagnostics);
            if (ePackage == null) continue;
            EClassifier sameNamedClassifier = ePackage.getEClassifier(type.getSimpleName());
            if (sameNamedClassifier != null && this.isMatchingInstanceClass(sameNamedClassifier, type)) {
                return sameNamedClassifier;
            }
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (this.isMatchingInstanceClass(eClassifier, type)) {
                    return eClassifier;
                }
                Class instanceClass = eClassifier.getInstanceClass();
                if ((relationship & 2) == 2 && this.isAssignableFromTo(type, instanceClass)) {
                    subtypes.add(eClassifier);
                }
                if ((relationship & 4) != 4 || !this.isAssignableFromTo(instanceClass, type)) continue;
                supertypes.add(eClassifier);
            }
        }
        if ((relationship & 2) == 2 && !subtypes.isEmpty()) {
            return (EClassifier)subtypes.first();
        }
        if ((relationship & 4) == 4 && !supertypes.isEmpty()) {
            return (EClassifier)supertypes.first();
        }
        return null;
    }

    private boolean isAssignableFromTo(Class<?> from, Class<?> to) {
        return from != null && to != null && to.isAssignableFrom(from);
    }

    private EClassifier lookupByInstanceClass(ParameterizedType type, int relationship) {
        assert (type != null);
        Type rawType = type.getRawType();
        EClassifier rawClassifier = this.toEClassifier(rawType, relationship);
        if (rawClassifier != null) {
            Iterator typeParameters = rawClassifier.getETypeParameters().iterator();
            Type[] typeArray = type.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type argumentType = typeArray[n2];
                EClassifier argumentClassifier = this.toEClassifier(argumentType, relationship);
                if (argumentClassifier != null && typeParameters.hasNext()) {
                    ETypeParameter typeParameter = (ETypeParameter)typeParameters.next();
                    for (EGenericType genericType : typeParameter.getEBounds()) {
                        EClassifier genericClassifier = genericType.getEClassifier();
                        Class genericInstanceClass = genericClassifier.getInstanceClass();
                        if (!(argumentType instanceof Class)) continue;
                        if ((relationship & 2) == 2 && !this.isAssignableFromTo((Class)argumentType, genericInstanceClass)) {
                            return null;
                        }
                        if ((relationship & 4) != 4 || this.isAssignableFromTo(genericInstanceClass, (Class)argumentType)) continue;
                        return null;
                    }
                }
                ++n2;
            }
        }
        return rawClassifier;
    }

    private EClassifier asEClassifier(Class<?> javaClass) {
        if (this.fHelperEClassiferAdapter == null) {
            EPackage ownerPackage = EcoreFactory.eINSTANCE.createEPackage();
            ownerPackage.setName("helper");
            ownerPackage.setNsURI(javaClass.getName());
            this.fHelperEClassiferAdapter = EcoreFactory.eINSTANCE.createEDataType();
            ownerPackage.getEClassifiers().add((Object)this.fHelperEClassiferAdapter);
        }
        this.fHelperEClassiferAdapter.setName(javaClass.getSimpleName());
        this.fHelperEClassiferAdapter.setInstanceClass(javaClass);
        return this.fHelperEClassiferAdapter;
    }

    private EPackage resolvePackage(String nsURI, DiagnosticChain diagnosticChain) {
        EPackage resolvedPackage;
        EPackage.Registry registry = this.fEnv.getEPackageRegistry();
        try {
            resolvedPackage = registry.getEPackage(nsURI);
        }
        catch (Throwable t) {
            resolvedPackage = null;
        }
        if (resolvedPackage != null) {
            return resolvedPackage;
        }
        diagnosticChain.add((Diagnostic)DiagnosticUtil.createErrorDiagnostic(NLS.bind(JavaBlackboxMessages.UnresolvedMetamodelURI, nsURI)));
        return null;
    }

    private boolean isMatchingInstanceClass(EClassifier eClassifier, Class<?> type) {
        EPackage ePackage;
        ModelContent genModelContent;
        Class instanceClass = eClassifier.getInstanceClass();
        if (type == instanceClass) {
            return true;
        }
        if (instanceClass == null && EmfUtil.isDynamic((EObject)eClassifier) && (genModelContent = this.getGenModelContent(ePackage = eClassifier.getEPackage())) != null) {
            try {
                if (Java2QVTTypeResolver.isMatchingInstanceGenClassifier(eClassifier, type, genModelContent)) {
                    return true;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isMatchingInstanceGenClassifier(EClassifier eClassifier, Class<?> type, ModelContent genModelContent) {
        for (EObject eObject : genModelContent.getContent()) {
            GenModel genModel;
            GenClassifier genClassifier;
            if (!(eObject instanceof GenModel) || (genClassifier = (genModel = (GenModel)eObject).findGenClassifier(eClassifier)) == null) continue;
            String classifierInstanceName = genClassifier.getRawInstanceClassName();
            if (!type.getName().equals(classifierInstanceName)) continue;
            return true;
        }
        return false;
    }

    private Map<String, URI> getGenModelMap() {
        if (this.genModelMap == null) {
            this.genModelMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
        }
        return this.genModelMap;
    }

    private ModelContent getGenModelContent(EPackage ePackage) {
        ModelContent result = this.genModelContentsMap.get(ePackage);
        if (result == null) {
            String nsURI = ePackage.getNsURI();
            Map<String, URI> genModelLocationMap = this.getGenModelMap();
            URI genModelUri = genModelLocationMap.get(nsURI);
            if (genModelUri != null) {
                ResourceSet resourceSet = ePackage.eResource().getResourceSet();
                result = EmfUtil.safeLoadModel((URI)genModelUri, (ResourceSet)resourceSet);
                this.genModelContentsMap.put(ePackage, result);
            }
        }
        return result;
    }
}

