/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.macosx;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.os.macosx.OSSupportMacOSXCocoa;
import org.eclipse.wb.os.OSSupport;

public abstract class OSSupportMacOSX
extends OSSupport {
    private static final String FLIP_FLAG = "windowbuilder.osx.flip";
    protected static final int DEFAULT_MENU_ITEM_OFFSET_X = 6;
    protected static final int DEFAULT_MENU_ITEM_OFFSET_Y = 5;
    private static final int TAB_ITEM_OFFSET_Y = 8;
    private static final int TAB_ITEM_EXTRA_WIDTH = 25;
    protected static final OSSupport INSTANCE = new OSSupportMacOSXCocoa.Cocoa64();
    private static boolean mustFlipImage;

    static {
        String osVersion = System.getProperties().get("os.version").toString();
        Object flip_flag_is_set = System.getProperties().get(FLIP_FLAG);
        int version = Integer.parseInt(osVersion.split("\\.")[0]);
        int mod = Integer.parseInt(osVersion.split("\\.")[1]);
        boolean isHighSierraOrMore = version > 10 || version == 10 && mod >= 13;
        mustFlipImage = flip_flag_is_set != null ? Boolean.getBoolean(FLIP_FLAG) : isHighSierraOrMore;
    }

    protected OSSupportMacOSX() {
    }

    public void beginShot(Control control) {
        DesignerPlugin.getShell().setRedraw(false);
        super.beginShot(control);
    }

    public void endShot(Control control) {
        super.endShot(control);
        DesignerPlugin.getShell().setRedraw(true);
    }

    public void makeShots(Control control) throws Exception {
        Image sourceShot = this.makeShot(control);
        if (mustFlipImage) {
            Image reverseShot = this.reverseImage(sourceShot);
            sourceShot.dispose();
            control.setData("WBP_IMAGE", (Object)reverseShot);
        }
        control.getShell().setVisible(false);
    }

    public Image reverseImage(Image image) {
        ImageData flip = OSSupportMacOSX.flip(image.getImageData(), false);
        ImageData rotate1 = OSSupportMacOSX.rotate(flip, 16384);
        ImageData rotate = OSSupportMacOSX.rotate(rotate1, 16384);
        Image result = new Image(image.getDevice(), rotate);
        return result;
    }

    static ImageData rotate(ImageData srcData, int direction) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[direction == 1024 ? srcData.height * destBytesPerLine : srcData.width * destBytesPerLine];
        int width = 0;
        int height = 0;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        width = srcData.width;
                        height = srcData.height;
                    }
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(width, height, srcData.depth, srcData.palette, srcData.scanlinePad, newData);
    }

    static ImageData flip(ImageData srcData, boolean vertical) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = srcData.width * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                if (vertical) {
                    destX = srcX;
                    destY = srcData.height - srcY - 1;
                } else {
                    destX = srcData.width - srcX - 1;
                    destY = srcY;
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, srcData.scanlinePad, newData);
    }

    protected static boolean isSeparatorItem(MenuItem item) {
        return (item.getStyle() & 2) != 0;
    }

    public Image getMenuBarVisualData(Menu menu, List<Rectangle> bounds) {
        String text;
        MenuItem item;
        int height = this.getDefaultMenuBarHeight();
        Image image = new Image((Device)menu.getDisplay(), menu.getParent().getSize().x, height);
        GC gc = new GC((Drawable)image);
        int menuWidth = 5;
        int i = 0;
        while (i < menu.getItemCount()) {
            item = menu.getItem(i);
            text = item.getText();
            int itemWidth = 5;
            if (text != null) {
                Point textDimensions = gc.stringExtent(text);
                itemWidth = textDimensions.x + 10;
            }
            bounds.add(new Rectangle(menuWidth, 0, itemWidth, height));
            menuWidth += itemWidth;
            ++i;
        }
        gc.dispose();
        if (image.getBounds().width < menuWidth) {
            image.dispose();
            image = new Image((Device)menu.getDisplay(), menuWidth, height);
        }
        gc = new GC((Drawable)image);
        gc.setBackground(ColorConstants.menuBackground);
        gc.fillRectangle(image.getBounds());
        gc.setForeground(ColorConstants.menuForeground);
        i = 0;
        while (i < menu.getItemCount()) {
            item = menu.getItem(i);
            text = item.getText();
            if (text != null) {
                Rectangle itemBounds = bounds.get(i);
                gc.drawString(text, itemBounds.x + 5, itemBounds.y + 2, true);
            }
            ++i;
        }
        gc.dispose();
        return image;
    }

    public Rectangle getMenuBarBounds(Menu menu) {
        throw new NotImplementedException("OSX menu bar bounds should be get using menu bar image.");
    }

    protected void fixupSeparatorItems(Menu menu, int[] bounds, int[] menuSize, int[] itemsBounds) {
        MenuItem firstItem = menu.getItem(0);
        int itemOffsetX = OSSupportMacOSX.isSeparatorItem(firstItem) ? 6 : itemsBounds[0];
        int itemOffsetY = OSSupportMacOSX.isSeparatorItem(firstItem) ? 5 : itemsBounds[1] / 2;
        int i = 0;
        while (i < menu.getItemCount()) {
            if (OSSupportMacOSX.isSeparatorItem(menu.getItem(i))) {
                if (i > 0) {
                    itemsBounds[i * 4 + 0] = itemsBounds[(i - 1) * 4 + 0];
                    itemsBounds[i * 4 + 1] = itemsBounds[(i - 1) * 4 + 1] + itemsBounds[(i - 1) * 4 + 3];
                } else {
                    itemsBounds[i * 4 + 0] = itemOffsetX;
                    itemsBounds[i * 4 + 1] = itemOffsetY * 2;
                }
                itemsBounds[i * 4 + 2] = menuSize[2];
                itemsBounds[i * 4 + 3] = 11;
            }
            bounds[i * 4 + 0] = itemsBounds[i * 4 + 0] - itemOffsetX;
            bounds[i * 4 + 1] = itemsBounds[i * 4 + 1] - itemOffsetY;
            bounds[i * 4 + 2] = itemsBounds[i * 4 + 2];
            bounds[i * 4 + 3] = itemsBounds[i * 4 + 3];
            ++i;
        }
    }

    public Rectangle getTabItemBounds(TabItem tabItem) {
        TabFolder folder = tabItem.getParent();
        GC gc = new GC((Drawable)folder);
        Point folderSize = folder.getSize();
        int thisItemOffsetX = 0;
        int thisItemWidth = 0;
        int thisItemHeight = 0;
        int itemsWidth = 0;
        int i = 0;
        while (i < folder.getItemCount()) {
            TabItem childItem = folder.getItem(i);
            Point itemSize = this.calculateItemSize(childItem, gc);
            if (childItem == tabItem) {
                thisItemOffsetX = itemsWidth;
                thisItemWidth = itemSize.x;
                thisItemHeight = itemSize.y;
            }
            itemsWidth += itemSize.x;
            ++i;
        }
        gc.dispose();
        return new Rectangle(folderSize.x / 2 - itemsWidth / 2 + thisItemOffsetX, 8, thisItemWidth, thisItemHeight);
    }

    private Point calculateItemSize(TabItem item, GC gc) {
        int width = 0;
        int imageHeight = 0;
        int textHeight = 0;
        Image image = item.getImage();
        String text = item.getText();
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            width = imageBounds.width + 2;
            imageHeight = imageBounds.height;
        }
        if (text != null && text.length() > 0) {
            Point stringExtent = gc.stringExtent(text);
            width += stringExtent.x;
            textHeight = stringExtent.y + 2;
        }
        return new Point(width + 25, Math.max(imageHeight, textHeight));
    }

    public boolean isPlusMinusTreeClick(Tree tree, int x, int y) {
        return false;
    }

    public int[] getPushButtonInsets() {
        return new int[4];
    }
}

