/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.rse.Messages;
import org.eclipse.dltk.core.internal.rse.RSEConnectionQueryManager;
import org.eclipse.dltk.core.internal.rse.RSEFileHandle;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RSEEnvironment
implements IEnvironment {
    private IRemoteFileSubSystem fs;
    private IHost host;
    private static final Map<IRemoteFileSubSystem, Boolean> tryToConnect = new HashMap<IRemoteFileSubSystem, Boolean>();

    public RSEEnvironment(IRemoteFileSubSystem fs) {
        this.fs = fs;
        this.host = fs.getConnectorService().getHost();
    }

    public boolean isLocal() {
        return false;
    }

    public IFileHandle getFile(IPath path) {
        if (path == null || Path.EMPTY.equals((Object)path)) {
            throw new IllegalArgumentException(Messages.RSEEnvironment_EmptyFileNameError);
        }
        return new RSEFileHandle((IEnvironment)this, RSEEnvironment.getURIFor(this.host, path.toString()));
    }

    public String getId() {
        return "org.eclipse.dltk.rse.rseEnvironment." + this.host.getAliasName();
    }

    public String getSeparator() {
        return this.fs.getSeparator();
    }

    public char getSeparatorChar() {
        return this.fs.getSeparatorChar();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEnvironment) {
            IEnvironment other = (IEnvironment)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getName() {
        return this.host.getAliasName() + Messages.RSEEnvironment_EnvironmentNameSuffix;
    }

    public IHost getHost() {
        return this.host;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public URI getURI(IPath location) {
        return RSEEnvironment.getURIFor(this.host, location.toString());
    }

    public String convertPathToString(IPath path) {
        if (this.host.getSystemType().isWindows()) {
            return path.toString().replace('/', '\\');
        }
        return path.toString();
    }

    public IFileHandle getFile(URI locationURI) {
        if ("rse".equalsIgnoreCase(locationURI.getScheme()) && locationURI.getHost().equals(this.host.getAliasName())) {
            return new RSEFileHandle((IEnvironment)this, locationURI);
        }
        URI[] resolved = EnvironmentManager.resolve((URI)locationURI);
        int i = 0;
        while (i < resolved.length) {
            URI newLocation = resolved[i];
            if ("rse".equalsIgnoreCase(newLocation.getScheme()) && newLocation.getHost().equals(this.host.getAliasName())) {
                return new RSEFileHandle((IEnvironment)this, newLocation);
            }
            ++i;
        }
        return null;
    }

    public String getPathsSeparator() {
        return Character.toString(this.getPathsSeparatorChar());
    }

    public char getPathsSeparatorChar() {
        return this.host.getSystemType().isWindows() ? (char)';' : ':';
    }

    public String getCanonicalPath(IPath path) {
        IFileHandle file = this.getFile(path);
        if (file instanceof RSEFileHandle) {
            RSEFileHandle handle = (RSEFileHandle)file;
            return handle.resolvePath();
        }
        return this.convertPathToString(path);
    }

    public static URI getURIFor(IHost host, String path) {
        return RSEFileSystem.getURIFor((String)host.getHostName(), (String)path);
    }

    public static IFileStore getStoreFor(URI locationURI) {
        return RSEFileSystem.getInstance().getStore(locationURI);
    }

    public boolean isConnected() {
        ISubSystem[] subSystems;
        ISubSystem[] iSubSystemArray = subSystems = this.host.getSubSystems();
        int n = subSystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IRemoteFileSubSystem) {
                return subsystem.isConnected();
            }
            ++n2;
        }
        return false;
    }

    public boolean connect() {
        return this.connect(false);
    }

    public boolean connect(boolean force) {
        if (this.isConnected()) {
            return true;
        }
        this.connectUnsafe(force);
        return this.isConnected();
    }

    private void connectUnsafe(boolean force) {
        boolean tryToConnect = this.isTryToConnect();
        if (force || tryToConnect) {
            RSEConnectionQueryManager.getInstance().connectTo(this.host);
            this.setTryToConnect(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTryToConnect() {
        boolean tryToConnect = true;
        Map<IRemoteFileSubSystem, Boolean> map = RSEEnvironment.tryToConnect;
        synchronized (map) {
            Boolean value = RSEEnvironment.tryToConnect.get(this.fs);
            if (value != null) {
                tryToConnect = value;
            }
        }
        return tryToConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTryToConnect(boolean value) {
        Map<IRemoteFileSubSystem, Boolean> map = tryToConnect;
        synchronized (map) {
            tryToConnect.put(this.fs, value);
        }
    }
}

