/*
 * Copyright (c) 2010-2012, 2015, 2016, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.common.branch;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.util.CDOVersionProvider;

/**
 * A pair of a {@link #getBranch() branch} and an integer {@link #getVersion() version} number.
 * <p>
 * It is often used in the context of
 * {@link CDORevisionManager#getRevisionByVersion(CDOID, CDOBranchVersion, int, boolean)
 * CDORevisionManager.getRevisionByVersion()}.
 *
 * @see CDOBranch#getVersion(int)
 * @author Eike Stepper
 * @since 3.0
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface CDOBranchVersion extends CDOBranchProvider, CDOVersionProvider
{
  /**
   * The fixed special version number <i>unspecified</i>.
   */
  public static final int UNSPECIFIED_VERSION = 0;

  /**
   * The fixed version number that is assigned to the first {@link CDORevision revision} of an {@link CDOID object} that
   * is committed to a particular branch .
   */
  public static final int FIRST_VERSION = 1;

  /**
   * Returns the branch of this branch version.
   */
  @Override
  public CDOBranch getBranch();

  /**
   * Returns the version number of this branch version.
   */
  @Override
  public int getVersion();
}
