/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

import org.eclipse.core.runtime.Assert;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;


public final class ConstraintCollector extends ASTVisitor {

	private final ConstraintCreator fCreator;
	private final Set<ITypeConstraint> fConstraints;

	public ConstraintCollector() {
		this(new FullConstraintCreator());
	}

	public ConstraintCollector(ConstraintCreator creator) {
		Assert.isNotNull(creator);
		fCreator= creator;
		fConstraints= new LinkedHashSet<>();
	}

	private void add(ITypeConstraint[] constraints){
		fConstraints.addAll(Arrays.asList(constraints));
	}

	public void clear(){
		fConstraints.clear();
	}

	public ITypeConstraint[] getConstraints(){
		return fConstraints.toArray(new ITypeConstraint[fConstraints.size()]);
	}

	//------------------------- visit methods -------------------------//

	@Override
	public boolean visit(AnonymousClassDeclaration node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ArrayAccess node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ArrayCreation node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ArrayInitializer node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ArrayType node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(AssertStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(Assignment node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(Block node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(BooleanLiteral node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(BreakStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(CastExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(CatchClause node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(CharacterLiteral node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ClassInstanceCreation node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(CompilationUnit node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ConditionalExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ConstructorInvocation node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ContinueStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(DoStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(EmptyStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ExpressionStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(FieldAccess node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(FieldDeclaration node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ForStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(IfStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ImportDeclaration node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(InfixExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(Initializer node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(InstanceofExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(Javadoc node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(LabeledStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(MarkerAnnotation node) {
		return false;
	}
	@Override
	public boolean visit(MethodDeclaration node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(MethodInvocation node) {
		add(fCreator.create(node));
		return true;
	}
	@Override
	public boolean visit(NormalAnnotation node) {
		return false;
	}
	@Override
	public boolean visit(NullLiteral node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(NumberLiteral node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(PackageDeclaration node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ParenthesizedExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(PostfixExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(PrefixExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(PrimitiveType node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(QualifiedName node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ReturnStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SimpleName node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SimpleType node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SingleMemberAnnotation node) {
		return false;
	}

	@Override
	public boolean visit(SingleVariableDeclaration node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(StringLiteral node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SuperConstructorInvocation node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SuperFieldAccess node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SuperMethodInvocation node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SwitchCase node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SwitchStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(SynchronizedStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ThisExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(ThrowStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(TryStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(TypeDeclaration node) {
		add(fCreator.create(node));
		return true;

		// TODO account for enums and annotations
	}

	@Override
	public boolean visit(TypeDeclarationStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(TypeLiteral node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(VariableDeclarationExpression node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(VariableDeclarationFragment node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(VariableDeclarationStatement node) {
		add(fCreator.create(node));
		return true;
	}

	@Override
	public boolean visit(WhileStatement node) {
		add(fCreator.create(node));
		return true;
	}
}
