/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.jeview.views.Null;

public class JEMemberValuePair
extends JEAttribute {
    private final JEAttribute fParent;
    private String fName;
    private IMemberValuePair fMemberValuePair;

    JEMemberValuePair(JEAttribute parent, String name, IMemberValuePair memberValuePair) {
        Assert.isNotNull((Object)parent);
        this.fParent = parent;
        this.fName = name;
        this.fMemberValuePair = memberValuePair;
    }

    JEMemberValuePair(JEAttribute parent, IMemberValuePair memberValuePair) {
        this(parent, null, memberValuePair);
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JEMemberValuePair other = (JEMemberValuePair)obj;
        if (!Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        if (!Objects.equals(this.fName, other.fName)) {
            return false;
        }
        return !(this.fMemberValuePair == null ? other.fMemberValuePair != null : !this.fMemberValuePair.getMemberName().equals(other.fMemberValuePair.getMemberName()));
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0) + (this.fMemberValuePair != null ? this.fMemberValuePair.getMemberName().hashCode() : 0);
    }

    @Override
    public Object getWrappedObject() {
        return this.fMemberValuePair;
    }

    @Override
    public JEAttribute[] getChildren() {
        if (this.fMemberValuePair == null) {
            return EMPTY;
        }
        Object value = this.fMemberValuePair.getValue();
        return new JEAttribute[]{JEMemberValuePair.createMVPairValue(this, "VALUE", value)};
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.fName != null) {
            sb.append(this.fName).append(": ");
        }
        sb.append("IMemberValuePair: ");
        if (this.fMemberValuePair == null) {
            sb.append(this.fMemberValuePair);
        } else {
            sb.append(this.fMemberValuePair.getMemberName());
        }
        return sb.toString();
    }

    static JEAttribute createMVPairValue(JEAttribute parent, String name, Object value) {
        if (value instanceof Object[]) {
            return JEMemberValuePair.createArrayValuedMVPair(parent, name, (Object[])value);
        }
        if (value instanceof IAnnotation) {
            return new JavaElement(parent, name, (IJavaElement)((IAnnotation)value));
        }
        if (value != null) {
            return new JavaElementProperty(parent, name, value);
        }
        return new Null(parent, name);
    }

    static JEAttribute createArrayValuedMVPair(JEAttribute parent, String name, final Object[] values) {
        return new JavaElementChildrenProperty(parent, name){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                JEAttribute[] children = new JEAttribute[values.length];
                int i = 0;
                while (i < values.length) {
                    Object value = values[i];
                    String childName = value == null ? "" : value.getClass().getSimpleName();
                    children[i] = JEMemberValuePair.createMVPairValue(this, childName, value);
                    ++i;
                }
                return children;
            }
        };
    }
}

