/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Array;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public final class IDEArrayBeanTypeProxy
extends IDEBeanTypeProxy
implements IArrayBeanTypeProxy {
    IBeanTypeProxy fFinalComponentType;
    IBeanTypeProxy fComponentType;
    String fTypeName;

    IDEArrayBeanTypeProxy(IDEProxyFactoryRegistry aRegistry, String aTypeName, Class aClass) {
        super(aRegistry, aClass);
        this.fTypeName = aTypeName;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public String getTypeName() {
        return this.fTypeName;
    }

    @Override
    public IBeanTypeProxy getFinalComponentType() {
        if (this.fFinalComponentType == null) {
            Class aType;
            int typeStart = this.getTypeName().lastIndexOf(91) + 1;
            this.fFinalComponentType = this.getTypeName().charAt(typeStart) == 'L' ? this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getTypeName().substring(typeStart + 1, this.getTypeName().length() - 1)) : ((aType = (Class)IDEStandardBeanTypeProxyFactory.MAP_SHORTSIG_TO_TYPE.get(this.getTypeName().substring(typeStart, typeStart + 1))) != null ? this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(aType.getName()) : null);
        }
        return this.fFinalComponentType;
    }

    @Override
    public IBeanTypeProxy getComponentType() {
        if (this.fComponentType == null) {
            this.fComponentType = this.getTypeName().charAt(1) != '[' ? this.getFinalComponentType() : this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getTypeName().substring(1));
        }
        return this.fComponentType;
    }

    @Override
    public int getDimensions() {
        return this.getTypeName().lastIndexOf(91) + 1;
    }

    @Override
    public IConstructorProxy getNullConstructorProxy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getConstructorProxy(String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy[] getConstructors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getDeclaredConstructorProxy(String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getDeclaredConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy[] getDeclaredConstructors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldProxy[] getFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getCompatibleConstructor(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getCompatibleMethod(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldProxy[] getDeclaredFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldProxy getFieldProxy(String fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, String argumentQualifiedTypeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy[] getMethods() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy[] getDeclaredMethods() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getDeclaredMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getDeclaredMethodProxy(String methodName, String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    IDEArrayBeanProxy createBeanProxyWith(int[] dimensions) throws ThrowableProxy {
        Object array;
        if (dimensions == null || dimensions.length == 0) {
            return this.createBeanProxyWith(new int[1]);
        }
        IBeanTypeProxy compType = null;
        int numDims = this.getDimensions();
        if (numDims <= dimensions.length) {
            compType = this.getFinalComponentType();
        } else {
            String compClass = this.getTypeName().substring(dimensions.length);
            compType = this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(compClass);
        }
        if (dimensions.length == 1) {
            array = Array.newInstance(((IDEBeanTypeProxy)compType).fClass, dimensions[0]);
            return new IDEArrayBeanProxy(this.fProxyFactoryRegistry, array, null);
        }
        array = Array.newInstance(((IDEBeanTypeProxy)compType).fClass, dimensions);
        return new IDEArrayBeanProxy(this.fProxyFactoryRegistry, array, null);
    }

    @Override
    protected IIDEBeanProxy newBeanProxy(Object anObject) {
        return new IDEArrayBeanProxy(this.fProxyFactoryRegistry, anObject, this);
    }

    @Override
    public String getFormalTypeName() {
        String name = this.getTypeName();
        int dims = name.lastIndexOf(91) + 1;
        String type = this.getFinalComponentType().getTypeName();
        StringBuffer formalType = new StringBuffer(type.length() + "[]".length() * dims);
        formalType.append(type);
        int i = 0;
        while (i < dims) {
            formalType.append("[]");
            ++i;
        }
        return formalType.toString();
    }
}

